<?php
/**
 * Theme Customizer - Service
 *
 * @package finwave
 */

namespace RT\Finwave\Api\Customizer\Sections;

use RT\Finwave\Api\Customizer;
use RT\Finwave\Helpers\Fns;
use RTFramework\Customize;

/**
 * Customizer class
 */
class Service extends Customizer {

	protected $section_service = 'rt_service_section';


	/**
	 * Register controls
	 * @return void
	 */
	public function register() {
		Customize::add_section( [
			'id'          => $this->section_service,
			'title'       => __( 'Service Option', 'finwave' ),
			'description' => __( 'Service Section', 'finwave' ),
			'priority'    => 36
		] );

		Customize::add_controls( $this->section_service, $this->get_controls() );
	}

	/**
	 * Get controls
	 * @return array
	 */
	public function get_controls() {
		return apply_filters( 'rt_service_controls', [

			'rt_service_archive_heading' => [
				'type'  => 'heading',
				'label' => __( 'Service Archive Option', 'finwave' ),
			],

			'rt_service_style' => [
				'type'        => 'select',
				'label'       => __( 'Service Layout', 'finwave' ),
				'description' => __( 'This service 02 layout only icon show', 'finwave' ),
				'default'     => 'default',
				'choices'     => [
					'default' => __( 'Service 01', 'finwave' ),
					'2'    => __( 'Service 02', 'finwave' ),
					'3'    => __( 'Service 03', 'finwave' ),
					'4'    => __( 'Service 04', 'finwave' ),
					'5'    => __( 'Service 05', 'finwave' ),
				]
			],

			'rt_service_item_number' => [
				'type'    => 'number',
				'label'   => __( 'Service Archive Item Limit', 'finwave' ),
				'default' => '8',
			],

			'rt_service_ar_excerpt' => [
				'type'    => 'switch',
				'label'   => __( 'Excerpt Visibility', 'finwave' ),
				'default' => 0
			],

			'rt_service_excerpt_limit' => [
				'type'    => 'number',
				'label'   => __( 'Content Limit', 'finwave' ),
				'default' => '15',
				'condition' => [ 'rt_service_ar_excerpt' ]
			],

			'rt_service_read_more' => [
				'type'    => 'switch',
				'label'   => __( 'Read More Visibility', 'finwave' ),
				'default' => 1
			],

			'rt_service_banner_archive_title' => [
				'type'    => 'text',
				'label'   => __( 'Archive Banner Title', 'finwave' ),
				'default' => __( 'Our Services', 'finwave' ),
			],

			'rt_service_slug' => [
				'type'    => 'text',
				'label'   => __( 'Archive Slug', 'finwave' ),
				'default' => 'service',
			],

			'rt_service_cat_slug' => [
				'type'    => 'text',
				'label'   => __( 'Category Slug', 'finwave' ),
				'default' => 'service-category',
			],

			'rt_service_single_related_heading' => [
				'type'  => 'heading',
				'label' => __( 'Service Single Related Option', 'finwave' ),
			],

			'rt_service_related' => [
				'type'    => 'switch',
				'label'   => __( 'Related Visibility', 'finwave' ),
				'default' => 0
			],

			'rt_service_related_title' => [
				'type'    => 'text',
				'label'   => __( 'Service Related Title', 'finwave' ),
				'default' => __( 'Related Service', 'finwave' ),
				'condition' => [ 'rt_service_related' ]
			],

			'rt_service_related_limit' => [
				'type'    => 'number',
				'label'   => __( 'Related Item Limit', 'finwave' ),
				'default' => 3,
				'condition' => [ 'rt_service_related' ]
			],

			'rt_service_related_query' => [
				'type'        => 'select',
				'label'       => __( 'Query Type', 'finwave' ),
				'description' => __( 'Service Query Type', 'finwave' ),
				'default'     => 'cat',
				'choices'     => [
					'cat' => esc_html__( 'Posts in the same Categories', 'finwave' ),
					'tag' => esc_html__( 'Posts in the same Tags', 'finwave' ),
					'author' => esc_html__( 'Posts by the same Author', 'finwave' ),
				],
				'condition' => [ 'rt_service_related' ]
			],

			'rt_service_related_sort' => [
				'type'        => 'select',
				'label'       => __( 'Sort Order', 'finwave' ),
				'description' => __( 'Display Service Order', 'finwave' ),
				'default'     => 'recent',
				'choices'     => [
					'recent' => esc_html__( 'Recent Posts', 'finwave' ),
					'rand' => esc_html__( 'Random Posts', 'finwave' ),
					'modified' => esc_html__( 'Last Modified Posts', 'finwave' ),
					'popular' => esc_html__( 'Most Commented posts', 'finwave' ),
					'views' => esc_html__( 'Most Viewed posts', 'finwave' ),
				],
				'condition' => [ 'rt_service_related' ]
			],

		] );
	}


}
