<?php
/**
 * Theme Customizer - Header
 *
 * @package finwave
 */

namespace RT\Finwave\Api\Customizer\Sections;

use RT\Finwave\Api\Customizer;
use RTFramework\Customize;

/**
 * Customizer class
 */
class Labels extends Customizer {
	protected $section_labels = 'rt_labels_section';

	/**
	 * Register controls
	 * @return void
	 */
	public function register() {
		Customize::add_section( [
			'id'          => $this->section_labels,
			'title'       => __( 'Modify Static Text', 'finwave' ),
			'description' => __( 'You can change all static text of the theme.', 'finwave' ),
			'priority'    => 999
		] );
		Customize::add_controls( $this->section_labels, $this->get_controls() );
	}

	/**
	 * Get controls
	 * @return array
	 */
	public function get_controls() {

		return apply_filters( 'rt_labels_controls', [

			'rt_header_labels' => [
				'type'  => 'heading',
				'label' => __( 'Header Labels', 'finwave' ),
			],

			'rt_get_menu_label' => [
				'type'        => 'text',
				'label'       => __( 'Menu Text', 'finwave' ),
				'description' => __( 'Content: Menu Button', 'finwave' ),
			],

			'rt_get_login_label' => [
				'type'        => 'text',
				'label'       => __( 'Log In', 'finwave' ),
				'default'     => __( 'Log In', 'finwave' ),
				'description' => __( 'Content: SignIn Button', 'finwave' ),
			],

			'rt_get_started_label' => [
				'type'        => 'text',
				'label'       => __( 'Get Started', 'finwave' ),
				'default'     => __( 'Get Started', 'finwave' ),
				'description' => __( 'Content: Get Started', 'finwave' ),
				'condition' => [ 'rt_get_started_button' ],
			],

			'rt_contact_info_label' => [
				'type'        => 'text',
				'label'       => __( 'Contact Info', 'finwave' ),
				'default'     => __( 'Contact Info', 'finwave' ),
				'description' => __( 'Content: Contact Info', 'finwave' ),
			],

			'rt_follow_us_label' => [
				'type'        => 'text',
				'label'       => __( 'Follow Us On', 'finwave' ),
				'default'     => __( 'Follow Us On', 'finwave' ),
				'description' => __( 'Content: Follow Us On', 'finwave' ),
			],

			'rt_about_label' => [
				'type'        => 'text',
				'label'       => __( 'About Us', 'finwave' ),
				'description' => __( 'Content: About Us', 'finwave' ),
			],

			'rt_about_text' => [
				'type'        => 'textarea',
				'label'       => __( 'About Text', 'finwave' ),
				'description' => __( 'Enter about text here.', 'finwave' ),
			],

			'rt_footer_labels' => [
				'type'  => 'heading',
				'label' => __( 'Footer Labels', 'finwave' ),
			],

			'rt_ready_label' => [
				'type'        => 'text',
				'label'       => __( 'Are You Ready', 'finwave' ),
				'default'     => __( 'ARE YOU READY TO GET STARTED?', 'finwave' ),
				'description' => __( 'Content: Footer Are You Ready', 'finwave' ),
			],

			'rt_contact_button_text' => [
				'type'        => 'text',
				'label'       => __( 'Contact Us', 'finwave' ),
				'default'     => __( 'Contact Us', 'finwave' ),
				'description' => __( 'Content: Footer contact button', 'finwave' ),
			],

			'rt_blog_labels' => [
				'type'  => 'heading',
				'label' => __( 'Blog Labels', 'finwave' ),
			],
			'rt_author_prefix' => [
				'type'        => 'text',
				'label'       => __( 'By', 'finwave' ),
				'default'     => 'by',
				'description' => __( 'Content: Meta Author Prefix', 'finwave' ),
			],
			'rt_tags'         => [
				'type'        => 'text',
				'label'       => __( 'Tags:', 'finwave' ),
				'default'     => __( 'Tags:', 'finwave' ),
				'description' => __( 'Content: Single blog footer tags label', 'finwave' ),
			],
			'rt_social' => [
				'type'        => 'text',
				'label'       => __( 'Socials:', 'finwave' ),
				'default'     => __( 'Socials:', 'finwave' ),
				'description' => __( 'Content: Single blog footer Socials label', 'finwave' ),
			],
			'rt_blog_read_more' => [
				'type'        => 'text',
				'label'       => __( 'Blog Read More:', 'finwave' ),
				'default'     => __( 'Continue Reading', 'finwave' ),
				'description' => __( 'Content: Single blog footer read more text', 'finwave' ),
			],

		] );
	}


}
