<?php
/**
 * Theme Customizer - Header
 *
 * @package finwave
 */

namespace RT\Finwave\Api\Customizer\Sections;

use RT\Finwave\Api\Customizer;
use RTFramework\Customize;

/**
 * Customizer class
 */
class General extends Customizer {
	protected $section_general = 'rt_general_section';

	/**
	 * Register controls
	 * @return void
	 */
	public function register() {
		Customize::add_section( [
			'id'          => $this->section_general,
			'title'       => __( 'General', 'finwave' ),
			'description' => __( 'General Section', 'finwave' ),
			'priority'    => 20
		] );
		Customize::add_controls( $this->section_general, $this->get_controls() );
	}

	/**
	 * Get controls
	 * @return array
	 */
	public function get_controls() {

		return apply_filters( 'rt_general_controls', [

			'rt_svg_enable' => [
				'type'  => 'switch',
				'label' => __( 'Enable SVG Upload', 'finwave' ),
				'default' => 1,
			],

			'rt_preloader' => [
				'type'  => 'switch',
				'label' => __( 'Preloader', 'finwave' ),
			],

			'rt_preloader_logo' => [
				'type'         => 'image',
				'label'        => __( 'Preloader Logo', 'finwave' ),
				'description'  => __( 'Upload preloader logo for your site.', 'finwave' ),
				'button_label' => __( 'Logo', 'finwave' ),
				'condition' => [ 'rt_preloader' ]
			],

			'preloader_bg_color' => [
				'type'    => 'color',
				'label'   => __( 'Preloader Background Color', 'finwave' ),
				'condition' => [ 'rt_preloader' ]
			],

			'rt_back_to_top' => [
				'type'  => 'switch',
				'label' => __( 'Back to Top', 'finwave' ),
			],

			'rt_remove_admin_bar' => [
				'type'        => 'switch',
				'label'       => __( 'Remove Admin Bar', 'finwave' ),
				'description' => __( 'This option not work for administrator role.', 'finwave' ),
			],

			'container_width' => [
				'type'    => 'select',
				'label'   => __( 'Container Width', 'finwave' ),
				'default' => '1364',
				'choices' => [
					'1554' => esc_html__( '1554px', 'finwave' ),
					'1364' => esc_html__( '1364px', 'finwave' ),
					'1240' => esc_html__( '1240px', 'finwave' ),
					'1200' => esc_html__( '1200px', 'finwave' ),
					'1140' => esc_html__( '1140px', 'finwave' ),
				]
			],

			'rt_blend' => [
				'type'        => 'switch',
				'label'       => __( 'Image Blend', 'finwave' ),
				'default' => 0,
				'description' => __( 'This option for use all image blend mode.', 'finwave' ),
			],

			'rt_google_fonts_enable' => [
				'type'  => 'switch',
				'label' => __( 'Enable Google Fonts', 'finwave' ),
				'default' => 1,
			],

		] );

	}

}
