<?php
/**
 * Theme Customizer - Header
 *
 * @package finwave
 */

namespace RT\Finwave\Api\Customizer\Sections;

use RT\Finwave\Api\Customizer;
use RT\Finwave\Helpers\Fns;
use RTFramework\Customize;

/**
 * Customizer class
 */
class Blog extends Customizer {

	protected $section_blog = 'rt_blog_section';


	/**
	 * Register controls
	 * @return void
	 */
	public function register() {
		Customize::add_section( [
			'id'          => $this->section_blog,
			'title'       => __( 'Blog Archive', 'finwave' ),
			'description' => __( 'Blog Section', 'finwave' ),
			'priority'    => 25
		] );

		Customize::add_controls( $this->section_blog, $this->get_controls() );
	}

	/**
	 * Get controls
	 * @return array
	 */
	public function get_controls() {
		return apply_filters( 'rt_blog_controls', [

			'rt_blog_style' => [
				'type'        => 'select',
				'label'       => __( 'Blog Style', 'finwave' ),
				'description' => __( 'This option works only for blog layout', 'finwave' ),
				'default'     => 'default',
				'choices'     => [
					'default' => __( 'Default From Theme', 'finwave' ),
					'list'    => __( 'List', 'finwave' ),
					'list-2'    => __( 'List 2', 'finwave' ),
					'grid-2'    => __( 'Grid 2', 'finwave' ),
					'grid-3'    => __( 'Grid 3', 'finwave' ),
					'grid-4'    => __( 'Grid 4', 'finwave' ),
				]
			],

			'rt_blog_column' => [
				'type'        => 'select',
				'label'       => __( 'Grid Column', 'finwave' ),
				'description' => __( 'This option works only for large device', 'finwave' ),
				'default'     => 'default',
				'choices'     => [
					'default'   => __( 'Default From Theme', 'finwave' ),
					'col-lg-12' => __( '1 Column', 'finwave' ),
					'col-lg-6'  => __( '2 Column', 'finwave' ),
					'col-lg-4'  => __( '3 Column', 'finwave' ),
					'col-lg-3'  => __( '4 Column', 'finwave' ),
				]
			],

			'rt_blog_column_gap' => [
				'type'        => 'select',
				'label'       => __( 'Grid Column Gap', 'finwave' ),
				'description' => __( 'This option works only for blog grid gap', 'finwave' ),
				'default'     => 'g-4',
				'choices'     => [
					'g-1'  => __( 'Gap 1', 'finwave' ),
					'g-2'  => __( 'Gap 2', 'finwave' ),
					'g-3'  => __( 'Gap 3', 'finwave' ),
					'g-4'  => __( 'Gap 4', 'finwave' ),
					'g-5'  => __( 'Gap 5', 'finwave' ),
				]
			],

			'rt_excerpt_limit' => [
				'type'    => 'number',
				'label'   => __( 'Content Limit', 'finwave' ),
				'default' => '25',
			],

			'rt_blog_btn_style' => [
				'type'        => 'select',
				'label'       => __( 'Button Style', 'finwave' ),
				'description' => __( 'This option works only for blog button style', 'finwave' ),
				'default'     => 'button-3',
				'choices'     => [
					'button-1'  => __( 'Default', 'finwave' ),
					'button-2'  => __( 'Button 2', 'finwave' ),
					'button-3'  => __( 'Button 3', 'finwave' ),
					'button-4'  => __( 'Button 4', 'finwave' ),
					'button-5'  => __( 'Button 5', 'finwave' ),
				]
			],

			'rt_blog_btn_radius' => [
				'type'    => 'number',
				'label'   => __( 'Button Radius', 'finwave' ),
				'default' => 6,
			],

			'rt_blog_pagination_style' => [
				'type'        => 'select',
				'label'       => __( 'Pagination Style', 'finwave' ),
				'description' => __( 'This option works only for blog pagination style', 'finwave' ),
				'default'     => 'pagination-area',
				'choices'     => [
					'pagination-area'  => __( 'Default', 'finwave' ),
					'pagination-area-2'  => __( 'Style 2', 'finwave' ),
				]
			],

			'rt_meta_heading' => [
				'type'  => 'heading',
				'label' => __( 'Post Meta Settings', 'finwave' ),
			],

			'rt_blog_meta_style' => [
				'type'    => 'select',
				'label'   => __( 'Meta Style', 'finwave' ),
				'default' => 'meta-style-default',
				'choices' => Fns::meta_style()
			],

			'rt_single_above_meta_style' => [
				'type'    => 'select',
				'label'   => __( 'Title Above Meta Style', 'finwave' ),
				'default' => 'meta-style-dash',
				'choices' => Fns::meta_style( [ 'meta-style-dash-bg', 'meta-style-pipe' ] )
			],

			'rt_blog_meta' => [
				'type'        => 'select2',
				'label'       => __( 'Choose Meta', 'finwave' ),
				'description' => __( 'You can sort meta by drag and drop', 'finwave' ),
				'placeholder' => __( 'Choose Meta', 'finwave' ),
				'multiselect' => true,
				'default'     => 'author,date,category',
				'choices'     => Fns::blog_meta_list(),
			],

			'rt_visibility' => [
				'type'  => 'heading',
				'label' => __( 'Visibility Section', 'finwave' ),
			],

			'rt_meta_visibility' => [
				'type'    => 'switch',
				'label'   => __( 'Meta Visibility', 'finwave' ),
				'default' => 1
			],

			'rt_blog_above_meta_visibility' => [
				'type'  => 'switch',
				'label' => __( 'Title Above Meta Visibility', 'finwave' ),
			],

			'rt_blog_content_visibility' => [
				'type'    => 'switch',
				'label'   => __( 'Entry Content Visibility', 'finwave' ),
				'default' => 1
			],

			'rt_video_visibility' => [
				'type'    => 'switch',
				'label'   => __( 'Video Visibility', 'finwave' ),
				'default' => 1
			],

			'rt_blog_footer_visibility' => [
				'type'    => 'switch',
				'label'   => __( 'Entry Footer Visibility', 'finwave' ),
				'default' => 1
			],

			'rt_animation_heading' => [
				'type'  => 'heading',
				'label' => __( 'Animation', 'finwave' ),
			],

			'rt_animation' => [
				'type'      => 'switch',
				'label'       => __( 'Animation', 'finwave' ),
				'default'     => 0,
			],

			'rt_animation_effect' => [
				'type'        => 'select',
				'label' => __( 'Entrance Animation', 'finwave' ),
				'description' => __( 'This option works only for blog animation effect', 'finwave' ),
				'default'     => 'fadeInUp',
				'choices'     => [
					'bounce' => esc_html__( 'bounce', 'finwave' ),
					'flash' => esc_html__( 'flash', 'finwave' ),
					'pulse' => esc_html__( 'pulse', 'finwave' ),
					'rubberBand' => esc_html__( 'rubberBand', 'finwave' ),
					'shakeX' => esc_html__( 'shakeX', 'finwave' ),
					'shakeY' => esc_html__( 'shakeY', 'finwave' ),
					'headShake' => esc_html__( 'headShake', 'finwave' ),
					'swing' => esc_html__( 'swing', 'finwave' ),
					'fadeIn' => esc_html__( 'fadeIn', 'finwave' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'finwave' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'finwave' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'finwave' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'finwave' ),
					'bounceIn' => esc_html__( 'bounceIn', 'finwave' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'finwave' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'finwave' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'finwave' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'finwave' ),
					'slideInUp' => esc_html__( 'slideInUp', 'finwave' ),
					'slideInDown' => esc_html__( 'slideInDown', 'finwave' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'finwave' ),
					'slideInRight' => esc_html__( 'slideInRight', 'finwave' ),
				],
				'condition' => [ 'rt_animation' ],
			],

			'delay' => [
				'type'  => 'text',
				'label' => __( 'Delay', 'finwave' ),
				'default' => '200',
				'condition' => [ 'rt_animation' ],
			],

			'duration' => [
				'type'  => 'text',
				'label' => __( 'Duration', 'finwave' ),
				'default' => '1200',
				'condition' => [ 'rt_animation' ],
			],

		] );
	}


}
