<?php
/**
 * Theme Customizer Pannels
 *
 * @package finwave
 */

namespace RT\Finwave\Api\Customizer;

use RT\Finwave\Traits\SingletonTraits;
use RTFramework\Customize;

/**
 * Customizer class
 */
class Pannels {
	use SingletonTraits;

	/**
	 * register default hooks and actions for WordPress
	 * @return
	 */
	public function __construct() {
		add_action( 'init', [ $this, 'add_panels' ] );
	}

	/**
	 * Add Panels
	 * @return void
	 */
	public function add_panels() {
		Customize::add_panels(
			[
				[
					'id'          => 'rt_header_panel',
					'title'       => esc_html__( 'Header - Topbar - Menu', 'finwave' ),
					'description' => esc_html__( 'Finwave Header', 'finwave' ),
					'priority'    => 22,
				],
				[
					'id'          => 'rt_typography_panel',
					'title'       => esc_html__( 'Typography', 'finwave' ),
					'description' => esc_html__( 'Finwave Typography', 'finwave' ),
					'priority'    => 24,
				],
				[
					'id'          => 'rt_color_panel',
					'title'       => esc_html__( 'Colors', 'finwave' ),
					'description' => esc_html__( 'Finwave Color Settings', 'finwave' ),
					'priority'    => 28,
				],
				[
					'id'          => 'rt_layouts_panel',
					'title'       => esc_html__( 'Layout Settings', 'finwave' ),
					'description' => esc_html__( 'Finwave Layout Settings', 'finwave' ),
					'priority'    => 34,
				],
				[
					'id'          => 'rt_contact_social_panel',
					'title'       => esc_html__( 'Contact & Socials', 'finwave' ),
					'description' => esc_html__( 'Finwave Contact & Socials', 'finwave' ),
					'priority'    => 24,
				],

			]
		);
	}

}
