import { registerBlockType } from '@wordpress/blocks';
import './style.scss';

/**
 * Internal dependencies
 */
import Edit from './edit';
import save from './save';
import metadata from './block.json';

registerBlockType( metadata.name, {
	icon: (
		<svg width="431" height="329" viewBox="0 0 431 329" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M325.81 236.557C322.815 229.898 315.446 226.575 308.154 226.935C282.914 228.181 259.518 213.722 249.224 190.836C234.682 158.504 249.238 122.231 280.619 108.117C287.597 104.979 296.182 103.152 304.836 102.99C312.245 102.852 319.479 98.8738 321.947 91.8862L333.507 59.1523C336.371 51.0436 331.842 42.0984 323.344 40.7809C300.196 37.1923 276.095 40.4096 253.578 50.537C191.767 78.3375 162.133 152.261 190.789 215.975C215.419 270.737 275.051 299.248 331.053 287.449C339.632 285.641 343.636 276.19 340.039 268.194L325.81 236.557ZM359.03 259.577C362.636 267.596 372.402 270.862 379.45 265.604C418.517 236.461 437.553 186.306 427.66 138.581C425.875 129.972 416.402 125.935 408.383 129.542L376.95 143.679C370.229 146.702 366.908 154.175 367.298 161.535C368.216 178.867 361.705 196.022 349.518 208.381C344.344 213.628 341.87 221.424 344.893 228.145L359.03 259.577ZM353.658 67.3565L341.466 99.4809C338.864 106.336 341.743 113.964 347.099 118.972C347.719 119.552 348.33 120.147 348.933 120.755C353.882 125.749 361.293 127.855 367.705 124.971L399.921 110.482C407.906 106.89 411.19 97.1826 405.977 90.1475C397.115 78.1871 386.181 68.0867 373.71 60.0497C366.322 55.2883 356.777 59.1388 353.658 67.3565ZM30.1514 0.413086C13.5828 0.413085 0.151365 13.8446 0.151367 30.4131L0.151382 299C0.151383 315.569 13.5828 329 30.1514 329H202.991C215.635 329 226.452 321.178 230.867 310.11C220.056 304.56 209.95 297.831 200.718 290.092C199.239 293.766 195.641 296.359 191.438 296.359H132.012C126.489 296.359 122.012 291.882 122.012 286.359L122.012 271.542C122.012 266.019 126.489 261.542 132.012 261.542H173.965C167.274 252.414 161.515 242.56 156.829 232.12V240.662C156.829 246.184 152.352 250.662 146.829 250.662H132.012C126.489 250.662 122.012 246.184 122.012 240.662V225.844C122.012 220.322 126.489 215.844 132.012 215.844H146.829C148.251 215.844 149.605 216.142 150.83 216.677C149.559 212.828 148.428 208.916 147.443 204.945C147.24 204.958 147.035 204.964 146.829 204.964L132.012 204.964C126.489 204.964 122.012 200.487 122.012 194.964L122.012 180.147C122.012 174.624 126.489 170.147 132.012 170.147H142.742C142.703 168.701 142.684 167.25 142.684 165.795C142.684 163.608 142.728 161.432 142.813 159.267H132.012C126.489 159.267 122.012 154.789 122.012 149.267V134.449C122.012 128.926 126.489 124.449 132.012 124.449L146.829 124.449C147.22 124.449 147.607 124.472 147.987 124.516C149.956 117.014 152.449 109.724 155.425 102.689L42.7925 102.689C37.2697 102.689 32.7925 98.2114 32.7925 92.6886L32.7925 43.0542C32.7925 37.5314 37.2697 33.0542 42.7925 33.0542H190.35C195.471 33.0542 199.692 36.9029 200.28 41.8653C209.818 33.8132 220.298 26.842 231.531 21.1408C227.625 9.11032 216.324 0.413083 202.991 0.413094L30.1514 0.413086ZM32.7925 134.449C32.7925 128.926 37.2697 124.449 42.7925 124.449H57.6097C63.1325 124.449 67.6097 128.926 67.6097 134.449V149.267C67.6097 154.789 63.1325 159.267 57.6097 159.267H42.7925C37.2697 159.267 32.7925 154.789 32.7925 149.267L32.7925 134.449ZM32.7925 180.147C32.7925 174.624 37.2697 170.147 42.7925 170.147H57.6097C63.1325 170.147 67.6097 174.624 67.6097 180.147L67.6097 194.964C67.6097 200.487 63.1325 204.964 57.6097 204.964H42.7925C37.2697 204.964 32.7925 200.487 32.7925 194.964V180.147ZM42.7925 215.844C37.2697 215.844 32.7925 220.322 32.7925 225.844V240.662C32.7925 246.184 37.2697 250.662 42.7925 250.662H57.6097C63.1325 250.662 67.6097 246.184 67.6097 240.662L67.6097 225.844C67.6097 220.322 63.1325 215.844 57.6097 215.844H42.7925ZM32.7925 271.542C32.7925 266.019 37.2697 261.542 42.7925 261.542H57.6097C63.1325 261.542 67.6097 266.019 67.6097 271.542V286.359C67.6097 291.882 63.1325 296.359 57.6097 296.359L42.7925 296.359C37.2697 296.359 32.7925 291.882 32.7925 286.359L32.7925 271.542ZM87.402 124.449C81.8792 124.449 77.402 128.926 77.402 134.449V149.267C77.402 154.789 81.8792 159.267 87.402 159.267L102.219 159.267C107.742 159.267 112.219 154.789 112.219 149.267V134.449C112.219 128.926 107.742 124.449 102.219 124.449L87.402 124.449ZM77.402 180.147C77.402 174.624 81.8792 170.147 87.402 170.147H102.219C107.742 170.147 112.219 174.624 112.219 180.147V194.964C112.219 200.487 107.742 204.964 102.219 204.964H87.402C81.8792 204.964 77.402 200.487 77.402 194.964V180.147ZM87.402 215.844C81.8792 215.844 77.402 220.322 77.402 225.844V240.662C77.402 246.184 81.8792 250.662 87.402 250.662H102.219C107.742 250.662 112.219 246.184 112.219 240.662V225.844C112.219 220.322 107.742 215.844 102.219 215.844L87.402 215.844ZM77.402 271.542C77.402 266.019 81.8792 261.542 87.402 261.542H102.219C107.742 261.542 112.219 266.019 112.219 271.542V286.359C112.219 291.882 107.742 296.359 102.219 296.359L87.402 296.359C81.8792 296.359 77.402 291.882 77.402 286.359L77.402 271.542Z" fill="black"/>
		</svg>
	),

	/**
	 * @see ./edit.js
	 */
	edit: Edit,

	/**
	 * @see ./save.js
	 */
	save,
} );
