<?php

namespace cBuilder\Classes;

class CCBTranslations {

	/**
	 * Frontend Translation Data
	 *
	 * @return array
	 */
	public static function get_frontend_translations() {
		$translations = array(
			'summary'                => __( 'Summary', 'cost-calculator-builder' ),
			'empty_end_date_error'   => __( 'Please select the second date', 'cost-calculator-builder' ),
			'wrong_date_range_error' => __( 'Please select correct date range values', 'cost-calculator-builder' ),
			'empty_end_time_error'   => __( 'Please select the second time', 'cost-calculator-builder' ),
			'required_field'         => __( 'This field is required', 'cost-calculator-builder' ),
			'min_required_single'    => __( 'option is required', 'cost-calculator-builder' ),
			'min_required_plural'    => __( 'options are required', 'cost-calculator-builder' ),
			'select_date_range'      => __( 'Select Date Range', 'cost-calculator-builder' ),
			'select_date'            => __( 'Select Date', 'cost-calculator-builder' ),
			'select_all'             => __( 'All dates', 'cost-calculator-builder' ),
			'select_discount_range'  => __( 'Set discount period', 'cost-calculator-builder' ),
			'select_discount_single' => __( 'Choose the day', 'cost-calculator-builder' ),
			'high_end_date_error'    => __( 'To date must be greater than from date', 'cost-calculator-builder' ),
			'high_end_multi_range'   => __( 'To value must be greater than from value', 'cost-calculator-builder' ),
			'wrong_file_url'         => __( 'Wrong file url', 'cost-calculator-builder' ),
			'big_file_size'          => __( 'File size is too big', 'cost-calculator-builder' ),
			'wrong_file_format'      => __( 'Wrong file format', 'cost-calculator-builder' ),
			'incorrect_email_format' => __( 'Incorrect email format', 'cost-calculator-builder' ),
			'form_no_payment'        => __( 'No Payment', 'cost-calculator-builder' ),
			'min_higher_max'         => __( 'Max value must be greater than min value', 'cost-calculator-builder' ),
			'must_be_between'        => __( 'Value must be between min and max values', 'cost-calculator-builder' ),
			'must_be_greater_min'    => __( 'Value can\'t be less than min value', 'cost-calculator-builder' ),
			'must_be_less_max'       => __( 'Value can\'t be greater than max value', 'cost-calculator-builder' ),
			'days'                   => __( 'day(s)', 'cost-calculator-builder' ),
			'files'                  => __( 'file(s)', 'cost-calculator-builder' ),
			'order_created'          => __( 'Order created', 'cost-calculator-builder' ),
			'clearLocation'          => __( 'Clear location', 'cost-calculator-builder' ),
			'cancel'                 => __( 'Cancel', 'cost-calculator-builder' ),
			'saveLocation'           => __( 'Save location', 'cost-calculator-builder' ),
			'openMap'                => __( 'Open map', 'cost-calculator-builder' ),
			'chooseFile'             => __( 'Choose file', 'cost-calculator-builder' ),
			'formula'                => array(
				'addition'              => __( 'Addition (+)', 'cost-calculator-builder' ),
				'subtraction'           => __( 'Subtraction (-)', 'cost-calculator-builder' ),
				'division'              => __( 'Division (/)', 'cost-calculator-builder' ),
				'remainder'             => __( 'Remainder (%)', 'cost-calculator-builder' ),
				'multiplication'        => __( 'Multiplication (*)', 'cost-calculator-builder' ),
				'open_bracket'          => __( 'Open bracket (', 'cost-calculator-builder' ),
				'close_bracket'         => __( 'Close bracket )', 'cost-calculator-builder' ),
				'math_pow'              => __( 'Math.pow(x, y) returns the value of x to the power of y:', 'cost-calculator-builder' ),
				'math_sqrt'             => __( 'Math.sqrt(x) returns the square root of x:', 'cost-calculator-builder' ),
				'math_abs'              => __( 'Math.abs(x)', 'cost-calculator-builder' ),
				'math_ceil'             => __( 'Math.ceil(x) returns the value of x rounded up to its nearest integer:', 'cost-calculator-builder' ),
				'math_min'              => __( 'Math.min(x, y) returns the value of x rounded down to its nearest integer:', 'cost-calculator-builder' ),
				'math_max'              => __( 'Math.max(x, y) returns the value of x rounded down to its nearest integer:', 'cost-calculator-builder' ),
				'math_floor'            => __( 'Math.floor(x) returns the value of x rounded down to its nearest integer:', 'cost-calculator-builder' ),
				'math_round'            => __( 'Math.round(x) returns the value of x rounded to its nearest integer:', 'cost-calculator-builder' ),
				'if_operator'           => __( 'If operator', 'cost-calculator-builder' ),
				'if_else_operator'      => __( 'If else operator', 'cost-calculator-builder' ),
				'boolean_and'           => __( 'Boolean operator ', 'cost-calculator-builder' ),
				'boolean_or'            => __( 'Boolean operator ||', 'cost-calculator-builder' ),
				'operator_more'         => __( 'Operator more than', 'cost-calculator-builder' ),
				'operator_less'         => __( 'Operator less than', 'cost-calculator-builder' ),
				'operator_less_equal'   => __( 'Operator less than equal', 'cost-calculator-builder' ),
				'operator_more_equal'   => __( 'Operator more than equal', 'cost-calculator-builder' ),
				'operator_not_equal'    => __( 'Operator not equal', 'cost-calculator-builder' ),
				'operator_strict_equal' => __( 'Operator strict equal', 'cost-calculator-builder' ),
			),
			'order_form'             => array(
				'no_form_to_delete' => __( 'There is only one form left and it can\'t be deleted', 'cost-calculator-builder' ),
				'delete_primary'    => __( 'To delete this field, enable the \'Primary mean of communication\' option in another email field.', 'cost-calculator-builder' ),
			),
			'phone_example'          => __( 'Example: ', 'cost-calculator-builder' ),
			'country_code'           => __( 'Country code ', 'cost-calculator-builder' ),
			'invalid_email'          => __( 'Invalid email', 'cost-calculator-builder' ),
			'invalid_url'            => __( 'Invalid url', 'cost-calculator-builder' ),
			'invalid_phone'          => __( 'Invalid phone number', 'cost-calculator-builder' ),
			'select_value'           => __( 'Select value', 'cost-calculator-builder' ),
			'select_values'          => __( 'Select values', 'cost-calculator-builder' ),
			'value_must_be_between'  => __( 'Value must be between', 'cost-calculator-builder' ),
			'min'                    => __( 'Min', 'cost-calculator-builder' ),
			'max'                    => __( 'Max', 'cost-calculator-builder' ),
			'allowed_limit_is'       => __( 'Allowed limit is', 'cost-calculator-builder' ),
			'characters'             => __( 'characters', 'cost-calculator-builder' ),
			'valid_email_address'    => __( 'Please enter a valid email address', 'cost-calculator-builder' ),
			'enter_valid_url'        => __( 'Please enter a valid URL', 'cost-calculator-builder' ),
			'have_promo_code'        => __( 'Have a promo code?', 'cost-calculator-builder' ),
			'promo_code_not_exist'   => __( 'Promo code does not exist', 'cost-calculator-builder' ),
			'promo_code_is_applied'  => __( 'Promo code is already applied', 'cost-calculator-builder' ),
			'promo_code'             => __( 'Promo code', 'cost-calculator-builder' ),
			'apply'                  => __( 'Apply', 'cost-calculator-builder' ),
			'applied_promo_codes'    => __( 'Applied promo codes', 'cost-calculator-builder' ),
			'hide'                   => __( 'Hide', 'cost-calculator-builder' ),
			'show'                   => __( 'Show', 'cost-calculator-builder' ),
			'characters_max'         => __( 'characters max', 'cost-calculator-builder' ),
			'edit'                   => __( 'Edit', 'cost-calculator-builder' ),
			'name'                   => __( 'Name', 'cost-calculator-builder' ),
			'total'                  => __( 'Total', 'cost-calculator-builder' ),
			'and'                    => __( 'and', 'cost-calculator-builder' ),
			'email_quote'            => __( 'Email Quote', 'cost-calculator-builder' ),
			'type_your_name'         => __( 'Type your name', 'cost-calculator-builder' ),
			'type_your_email'        => __( 'Type your Email', 'cost-calculator-builder' ),
			'enter_message'          => __( 'Enter message', 'cost-calculator-builder' ),
			'email'                  => __( 'Email', 'cost-calculator-builder' ),
			'message'                => __( 'Message', 'cost-calculator-builder' ),
			'select'                 => __( 'Select', 'cost-calculator-builder' ),
			'default_total'          => __( 'Total', 'cost-calculator-builder' ),
			'off'                    => __( 'off', 'cost-calculator-builder' ),
			'back'                   => __( 'Back', 'cost-calculator-builder' ),
		);

		return apply_filters( 'ccb_frontend_translations', $translations );
	}

	public static function get_backend_translations() {
		return array(
			'summary'                        => esc_html__( 'Summary', 'cost-calculator-builder' ),
			'bulk_action_attention'          => esc_html__( 'Are you sure to "%s" choosen Calculators?', 'cost-calculator-builder' ),
			'copied'                         => esc_html__( 'Copied', 'cost-calculator-builder' ),
			'not_selected_calculators'       => esc_html__( 'No calculators were selected', 'cost-calculator-builder' ),
			'select_bulk'                    => esc_html__( 'Select bulk action', 'cost-calculator-builder' ),
			'changes_saved'                  => esc_html__( 'Changes Saved', 'cost-calculator-builder' ),
			'calculator_deleted'             => esc_html__( 'Calculator Deleted', 'cost-calculator-builder' ),
			'calculator_duplicated'          => esc_html__( 'Calculator Duplicated', 'cost-calculator-builder' ),
			'condition_link_saved'           => esc_html__( 'Condition Link Saved', 'cost-calculator-builder' ),
			'required_field'                 => esc_html__( 'This field is required', 'cost-calculator-builder' ),
			'delete_order_info'              => esc_html__( 'You are going to delete order', 'cost-calculator-builder' ),
			'success_deleted'                => esc_html__( 'Items successfully deleted', 'cost-calculator-builder' ),
			'not_selected'                   => esc_html__( 'Please choose at least one value', 'cost-calculator-builder' ),
			'select_image'                   => esc_html__( 'Select an image', 'cost-calculator-builder' ),
			'find_element'                   => esc_html__( 'Find Element', 'cost-calculator-builder' ),
			'enter_title'                    => esc_html__( 'Enter title', 'cost-calculator-builder' ),
			'no_element'                     => esc_html__( 'No elements on  canvas', 'cost-calculator-builder' ),
			'all_in_canvas'                  => esc_html__( 'All', 'cost-calculator-builder' ),
			'triggers_other_field'           => esc_html__( 'Impact other fields', 'cost-calculator-builder' ),
			'affects_by_other_field'         => esc_html__( 'Affected by other fields', 'cost-calculator-builder' ),
			'format_error'                   => sprintf( '%s <br> %s', __( 'File format is not supported.', 'cost-calculator-builder' ), __( 'Supported file formats: JPG, PNG', 'cost-calculator-builder' ) ),
			'primary_means_of_communication' => esc_html__( 'Primary mean of communication', 'cost-calculator-builder' ),
			'order_no_payment'               => esc_html__( 'No Payment', 'cost-calculator-builder' ),
			'order_cash_payment'             => esc_html__( 'Cash Payment', 'cost-calculator-builder' ),
			'order_status_pending'           => esc_html__( 'Pending', 'cost-calculator-builder' ),
			'order_status_complete'          => esc_html__( 'Complete', 'cost-calculator-builder' ),
			'cash_payment'                   => esc_html__( 'Cash Payment', 'cost-calculator-builder' ),
			'stripe'                         => esc_html__( 'Stripe', 'cost-calculator-builder' ),
			'paypal'                         => esc_html__( 'PayPal', 'cost-calculator-builder' ),
			'razorpay'                       => esc_html__( 'Razorpay', 'cost-calculator-builder' ),
			'no_payment'                     => esc_html__( 'No Payment', 'cost-calculator-builder' ),
			'no_payments'                    => esc_html__( 'No Payment', 'cost-calculator-builder' ),
			'woocommerce'                    => esc_html__( 'WooCommerce', 'cost-calculator-builder' ),
		);
	}

	public static function get_analytics_translations() {
		return array(
			'calculator_list' => __( 'Calculator List', 'cost-calculator-builder' ),
			'analytics'       => __( 'Analytics', 'cost-calculator-builder' ),
			'dashboard'       => __( 'Dashboard', 'cost-calculator-builder' ),
			'calculators'     => __( 'Calculators', 'cost-calculator-builder' ),
			'all_time'        => __( 'All time', 'cost-calculator-builder' ),
			'today'           => __( 'Today', 'cost-calculator-builder' ),
			'yesterday'       => __( 'Yesterday', 'cost-calculator-builder' ),
			'last_7_days'     => __( 'Last 7 days', 'cost-calculator-builder' ),
			'last_30_days'    => __( 'Last 30 days', 'cost-calculator-builder' ),
			'last_90_days'    => __( 'Last 90 days', 'cost-calculator-builder' ),
			'last_year'       => __( 'Last year', 'cost-calculator-builder' ),
			'custom'          => __( 'Custom', 'cost-calculator-builder' ),
			'all_statuses'    => __( 'All statuses', 'cost-calculator-builder' ),
			'completed'       => __( 'Completed', 'cost-calculator-builder' ),
			'pending'         => __( 'Pending', 'cost-calculator-builder' ),
			'charts'          => __( 'Charts', 'cost-calculator-builder' ),
			'widgets'         => __( 'Widgets', 'cost-calculator-builder' ),
			'select_period'   => __( 'Select period', 'cost-calculator-builder' ),
			'page_settings'   => __( 'Page settings', 'cost-calculator-builder' ),
			'pro_version'     => __( '🔒 Analytics is available in the Pro version', 'cost-calculator-builder' ),
			'upgrade_now'     => __( 'Upgrade now to unlock insights, track users, optimize sales, and grow your revenue.', 'cost-calculator-builder' ),
			'upgrade_now_btn' => __( 'Upgrade now', 'cost-calculator-builder' ),
			'enable_all'      => __( 'Enable all', 'cost-calculator-builder' ),
			'cancel'          => __( 'Cancel', 'cost-calculator-builder' ),
			'ok'              => __( 'OK', 'cost-calculator-builder' ),
			'apply'           => __( 'Apply', 'cost-calculator-builder' ),
			'deleted'         => __( 'Deleted', 'cost-calculator-builder' ),
			'hourly'          => __( 'Hourly', 'cost-calculator-builder' ),
			'weekly'          => __( 'Weekly', 'cost-calculator-builder' ),
			'monthly'         => __( 'Monthly', 'cost-calculator-builder' ),
			'yearly'          => __( 'Yearly', 'cost-calculator-builder' ),
			'hide'            => __( 'Hide', 'cost-calculator-builder' ),
			'small_large'     => __( 'Small/Large', 'cost-calculator-builder' ),
			'type'            => __( 'Type', 'cost-calculator-builder' ),
			'select_widget'   => __( 'Select widget', 'cost-calculator-builder' ),
			'add_widget'      => __( 'Add widget', 'cost-calculator-builder' ),
			'interactions'    => __( 'Interactions', 'cost-calculator-builder-pro' ),
			'revenue'         => __( 'Revenue', 'cost-calculator-builder-pro' ),
			'orders'          => __( 'Orders', 'cost-calculator-builder-pro' ),
			'views'           => __( 'Views', 'cost-calculator-builder-pro' ),
		);
	}
}
