<div class="cbb-edit-field-container">
	<div class="ccb-edit-field-header">
		<div class="ccb-edit-field-header-left" @click="$emit( 'cancel' )">
			<span class="ccb-edit-back-icon"><i class="ccb-icon-Path-3398"></i></span>
			<div class="ccb-edit-header-button">
				<div class="ccb-edit-header-top">
					<button class="ccb-edit-back-button"><?php esc_html_e( 'Back', 'cost-calculator-builder-pro' ); ?></button>
					<span class="ccb-edit-back-separator">/</span>
					<span class="ccb-edit-field-title" v-if="timeField.label && timeField.label.length > 0">{{ timeField.label }}</span>
					<span class="ccb-edit-field-title" v-else><?php esc_html_e( 'Time picker', 'cost-calculator-builder-pro' ); ?></span>
				</div>
				<span class="ccb-edit-field-alias">[{{ timeField.alias }}]</span>
			</div>
		</div>
		<div class="ccb-edit-field-header-right">
			<div class="ccb-save-wrapper" style="display: flex; justify-content: flex-end;">
				<button class="ccb-button success" @click.prevent="saveField"><?php esc_html_e( 'Save', 'cost-calculator-builder-pro' ); ?></button>
			</div>
		</div>
	</div>
	<div class="ccb-grid-box">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="ccb-edit-field-switch">
						<div class="ccb-edit-field-switch-item ccb-default-title" :class="{active: tab === 'main'}" @click="tab = 'main'">
							<?php esc_html_e( 'Element', 'cost-calculator-builder-pro' ); ?>
						</div>
						<div class="ccb-edit-field-switch-item ccb-default-title" :class="{active: tab === 'options'}" @click="tab = 'options'">
							<?php esc_html_e( 'Settings', 'cost-calculator-builder-pro' ); ?>
							<span class="ccb-fields-required" v-if="errorsCount > 0">{{ errorsCount }}</span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="container" v-show="tab === 'main'">
			<div class="row ccb-p-t-15">
				<div class="col-6">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( 'Name', 'cost-calculator-builder-pro' ); ?></span>
						<input type="text" v-model.trim="timeField.label" placeholder="<?php esc_attr_e( 'Enter field name', 'cost-calculator-builder-pro' ); ?>">
					</div>
				</div>
				<div class="col-3 ccb-p-l-0">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( 'Hours', 'cost-calculator-builder-pro' ); ?></span>
						<input type="text" v-model.trim="timeField.placeholderHours" placeholder="<?php esc_attr_e( 'hh', 'cost-calculator-builder-pro' ); ?>">
					</div>
				</div>
				<div class="col-3 ccb-p-l-0">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( 'Minutes', 'cost-calculator-builder-pro' ); ?></span>
						<input type="text" v-model.trim="timeField.placeholderTime" placeholder="<?php esc_attr_e( 'mm', 'cost-calculator-builder-pro' ); ?>">
					</div>
				</div>
				<div class="col-12 ccb-p-t-15">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( 'Description', 'cost-calculator-builder-pro' ); ?></span>
						<input type="text" v-model.trim="timeField.description" placeholder="<?php esc_attr_e( 'Enter field description', 'cost-calculator-builder-pro' ); ?>">
					</div>
				</div>
			</div>
			<div class="row ccb-p-t-15">
				<div class="col-12">
					<div class="ccb-builder-radio-wrapper">
						<span class="ccb-radio-label"><?php esc_html_e( 'Width', 'cost-calculator-builder-pro' ); ?></span>
						<div class="ccb-radio-box">
							<input class="ccb-builder-radio__radio" :id="'ccb-width-25-' + timeField.alias" type="radio" :name="'width-' + timeField.alias" value="25" v-model="timeField.width" @change="document.dispatchEvent(new CustomEvent('ccb_field_width_change', { detail: { alias: id.alias, width: 25 } }))">
							<label class="ccb-builder-radio__option" :for="'ccb-width-25-' + timeField.alias"><?php esc_html_e( '25%', 'cost-calculator-builder-pro' ); ?></label>

							<input class="ccb-builder-radio__radio" :id="'ccb-width-50-' + timeField.alias" type="radio" :name="'width-' + timeField.alias" value="50" v-model="timeField.width" @change="document.dispatchEvent(new CustomEvent('ccb_field_width_change', { detail: { alias: id.alias, width: 50 } }))">
							<label class="ccb-builder-radio__option" :for="'ccb-width-50-' + timeField.alias"><?php esc_html_e( '50%', 'cost-calculator-builder-pro' ); ?></label>

							<input class="ccb-builder-radio__radio" :id="'ccb-width-75-' + timeField.alias" type="radio" :name="'width-' + timeField.alias" value="75" v-model="timeField.width" @change="document.dispatchEvent(new CustomEvent('ccb_field_width_change', { detail: { alias: id.alias, width: 75 } }))">
							<label class="ccb-builder-radio__option" :for="'ccb-width-75-' + timeField.alias"><?php esc_html_e( '75%', 'cost-calculator-builder-pro' ); ?></label>

							<input class="ccb-builder-radio__radio" :id="'ccb-width-100-' + timeField.alias" type="radio" :name="'width-' + timeField.alias" value="100" v-model="timeField.width" @change="document.dispatchEvent(new CustomEvent('ccb_field_width_change', { detail: { alias: id.alias, width: 100 } }))">
							<label class="ccb-builder-radio__option" :for="'ccb-width-100-' + timeField.alias"><?php esc_html_e( '100%', 'cost-calculator-builder-pro' ); ?></label>
						</div>
					</div>
				</div>
			</div>
			<div class="row vertical-center ccb-p-t-15">
				<div class="col-6">
					<div class="ccb-select-box">
						<span class="ccb-select-label"><?php esc_html_e( 'Time Selection', 'cost-calculator-builder-pro' ); ?></span>
						<div class="ccb-select-wrapper">
							<i class="ccb-icon-Path-3485 ccb-select-arrow"></i>
							<select class="ccb-select" v-model="timeField.range">
								<option value="0"><?php esc_html_e( 'Basic (without range)', 'cost-calculator-builder-pro' ); ?></option>
								<option value="1"><?php esc_html_e( 'Advanced (with range)', 'cost-calculator-builder-pro' ); ?></option>
							</select>
						</div>
					</div>
				</div>
				<div class="col-6">
					<span class="ccb-select-label ccb-empty-label">&#20</span>
					<div class="ccb-input-wrapper">
						<div class="list-header">
							<div class="ccb-switch">
								<input type="checkbox" v-model="timeField.format"/>
								<label></label>
							</div>
							<h6><?php esc_html_e( '24-hour time', 'cost-calculator-builder-pro' ); ?></h6>
						</div>
					</div>
				</div>
			</div>
			<div class="row vertical-center ccb-p-t-15" v-if="timeField.range == 1">
				<div class="col-6">
					<span class="ccb-select-label ccb-empty-label">&#20</span>
					<div class="ccb-input-wrapper">
						<div class="list-header">
							<div class="ccb-switch">
								<input type="checkbox" v-model="timeField.use_interval"/>
								<label></label>
							</div>
							<h6><?php esc_html_e( 'Set minimum interval', 'cost-calculator-builder-pro' ); ?></h6>
						</div>
					</div>
				</div>
			</div>
			<div class="row vertical-center ccb-p-t-15" v-if="timeField.range == 1 && timeField.use_interval">
				<div class="col-6">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( 'Minimum interval (For ex. 1h, 1h 30m, 30m)', 'cost-calculator-builder-pro' ); ?></span>
						<div style="position: relative">
							<input type="text" :class="{'ccb-input-required': isInvalidInput}" v-model.trim="timeField.min_interval" placeholder="<?php esc_attr_e( 'Enter interval', 'cost-calculator-builder-pro' ); ?>">
							<span style="bottom: unset; top: -30px; font-weight: 700" v-if="isInvalidInput" class="ccb-error-tip default"><?php esc_html_e( 'Invalid format', 'cost-calculator-builder-pro' ); ?></span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="container" v-show="tab === 'options'">
			<div class="row ccb-p-t-15 switch-row">
				<div class="col-6">
					<div class="list-header">
						<div class="ccb-switch">
							<input type="checkbox" v-model="timeField.required"/>
							<label></label>
						</div>
						<h6><?php esc_html_e( 'Required', 'cost-calculator-builder-pro' ); ?></h6>
					</div>
				</div>
				<div class="col-6">
					<div class="list-header">
						<div class="ccb-switch">
							<input type="checkbox" v-model="timeField.addToSummary"/>
							<label></label>
						</div>
						<h6><?php esc_html_e( 'Show in Grand Total', 'cost-calculator-builder-pro' ); ?></h6>
					</div>
				</div>
				<div class="col-12" v-if="!disableFieldHiddenByDefault(timeField)">
					<div class="list-header">
						<div class="ccb-switch">
							<input type="checkbox" v-model="timeField.hidden"/>
							<label></label>
						</div>
						<h6><?php esc_html_e( 'Hidden by Default', 'cost-calculator-builder-pro' ); ?></h6>
					</div>
				</div>
			</div>
			<div class="row ccb-p-t-15 ccb-p-t-20">
				<div class="col-12">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( 'Additional Classes', 'cost-calculator-builder-pro' ); ?></span>
						<textarea v-model="timeField.additionalStyles" placeholder="<?php esc_attr_e( 'Set Additional Classes', 'cost-calculator-builder-pro' ); ?>"></textarea>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
