<?php

namespace cBuilder\Classes;

class CCBAiHelper {
	public static function generate_formula() {
		check_ajax_referer( 'ccb_generate_formula', 'nonce' );

		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json_error( __( 'You are not allowed to run this action', 'cost-calculator-builder' ) );
		}

		$result = array(
			'success' => false,
			'message' => __( 'Could not generate formula', 'cost-calculator-builder' ),
		);

		$request_body = file_get_contents( 'php://input' );
		$request_data = json_decode( $request_body, true );
		$data         = apply_filters( 'stm_ccb_sanitize_array', $request_data );

		if ( ! empty( $data['prompt'] ) ) {
			$prompt           = $data['prompt'];
			$general_settings = CCBSettingsData::get_calc_global_settings();
			$api_key          = $general_settings['ai']['gpt_api_key'] ?? '';
			$url              = 'https://api.openai.com/v1/chat/completions';

			$args = array(
				'body'    => json_encode( // phpcs:ignore
					array(
						'model'      => 'gpt-3.5-turbo',
						'messages'   => array(
							array(
								'role'    => 'system',
								'content' => 'You are a helpful assistant designed to generate formula for Wordpress Cost-calculator-builder plugin.',
							),
							array(
								'role'    => 'user',
								'content' => $prompt,
							),
						),
						'max_tokens' => 200,
					)
				),
				'headers' => array(
					'Content-Type'  => 'application/json',
					'Authorization' => 'Bearer ' . $api_key,
				),
			);

			$response = wp_remote_post( $url, $args );

			if ( is_wp_error( $response ) ) {
				$result['message'] = $response->get_error_message();
				wp_send_json( $result );
			}

			$body    = wp_remote_retrieve_body( $response );
			$res     = json_decode( $body, true );
			$content = $res['choices'][0]['message']['content'] ?? '';

			if ( ! empty( $content ) ) {
				$result['success'] = true;
				$result['message'] = 'Formula generated by AI';
				$result['data']    = array(
					'formula' => $content,
				);
			}
		}

		wp_send_json( $result );
	}
}
