<?php

namespace cBuilder\Classes\Analytics;

class CCBFieldAnalytics {
	public static function parse_numbers_field( $alias, $temp_data ) {
		$calc_id    = sanitize_text_field( $_GET['calc_id'] );
		$calculator = get_post_meta( $calc_id, 'stm-fields', true );

		if ( ! $calculator ) {
			return null;
		}

		$numbers_field = null;
		$numbers_field = self::find_field_recursively( $calculator, $alias );

		if ( ! $numbers_field ) {
			return null;
		}

		$min   = 0;
		$max   = 100;
		$title = isset( $numbers_field['label'] ) ? $numbers_field['label'] : $numbers_field['text'];

		if ( isset( $numbers_field['min'] ) && isset( $numbers_field['max'] ) ) {
			$min = (int) $numbers_field['min'];
			$max = (int) $numbers_field['max'];
		}

		if ( isset( $numbers_field['minValue'] ) && isset( $numbers_field['maxValue'] ) ) {
			$min = (int) $numbers_field['minValue'];
			$max = (int) $numbers_field['maxValue'];
		}

		$range      = $max - $min + 1;
		$max_groups = 20;

		if ( $range <= 20 ) {
			$group_size = 1;
		} else {
			$base_group_size = max( 1, ceil( $range / $max_groups ) );

			if ( $base_group_size <= 5 ) {
				$group_size = $base_group_size;
			} elseif ( $base_group_size <= 10 ) {
				$group_size = 5;
			} elseif ( $base_group_size <= 25 ) {
				$group_size = 10;
			} elseif ( $base_group_size <= 50 ) {
				$group_size = 25;
			} elseif ( $base_group_size <= 100 ) {
				$group_size = 50;
			} else {
				$magnitude  = pow( 10, floor( log10( $base_group_size ) ) );
				$group_size = ceil( $base_group_size / $magnitude ) * $magnitude;
			}
		}

		$categories  = array();
		$series      = array();
		$temp_groups = array();

		$start = floor( $min / $group_size ) * $group_size;
		if ( $start < $min ) {
			$start = $min;
		}

		$current = $start;

		while ( $current <= $max ) {
			$group_start = $current;
			$group_end   = min( $max, $current + $group_size - 1 );

			$temp_groups[] = array(
				'start' => $group_start,
				'end'   => $group_end,
			);

			$current += $group_size;
		}

		if ( count( $temp_groups ) > 1 ) {
			$last_group = end( $temp_groups );
			if ( $last_group['start'] === $last_group['end'] ) {
				array_pop( $temp_groups );
				$temp_groups[ count( $temp_groups ) - 1 ]['end'] = $last_group['end']; // phpcs:ignore
			}
		}

		foreach ( $temp_groups as $temp_group ) {
			$categories[] = $temp_group['start'] . '-' . $temp_group['end'];
			$series[]     = 0;
		}

		if ( isset( $temp_data[ $alias ] ) ) {
			foreach ( $temp_data[ $alias ] as $field_value ) {
				$int_value = (int) $field_value;
				if ( $int_value >= $min && $int_value <= $max ) {
					foreach ( $temp_groups as $index => $temp_group ) {
						if ( $int_value >= $temp_group['start'] && $int_value <= $temp_group['end'] ) {
							$series[ $index ]++;
							break;
						}
					}
				}
			}
		}

		return array(
			$alias => array(
				'title'       => $title,
				'categories'  => $categories,
				'series'      => $series,
				'type'        => 'columns',
				'key'         => $alias,
				'minValue'    => $min,
				'extraSeries' => array(),
			),
		);
	}

	public static function parse_single_options_field( $alias, $temp_data ) {
		$calc_id    = sanitize_text_field( $_GET['calc_id'] );
		$calculator = get_post_meta( $calc_id, 'stm-fields', true );

		if ( ! $calculator ) {
			return null;
		}

		$options_field = null;
		$options_field = self::find_field_recursively( $calculator, $alias );

		if ( ! $options_field ) {
			return null;
		}

		$title   = isset( $options_field['label'] ) ? $options_field['label'] : $options_field['text'];
		$options = isset( $options_field['options'] ) ? $options_field['options'] : array();

		if ( empty( $options ) ) {
			return null;
		}

		$categories = array();
		$option_map = array();

		foreach ( $options as $index => $option ) {
			$option_label = isset( $option['optionText'] ) ? $option['optionText'] : 'Untitled option';

			$categories[]         = $option_label;
			$option_map[ $index ] = $option_label;
		}

		$series = array_fill( 0, count( $categories ), 0 );

		if ( isset( $temp_data[ $alias ] ) ) {
			foreach ( $temp_data[ $alias ] as $field_value ) {
				if ( is_array( $field_value ) && isset( $field_value['temps'] ) ) {
					foreach ( $field_value['temps'] as $temp_value ) {
						$parts = explode( '_', $temp_value );
						if ( count( $parts ) >= 2 ) {
							$option_index = (int) end( $parts );

							if ( isset( $option_map[ $option_index ] ) ) {
								$series[ $option_index ]++;
							}
						}
					}
				}
			}
		}

		$type = 'bar';
		if ( str_contains( $alias, 'radio' ) ) {
			$type = 'pie';
		}

		return array(
			$alias => array(
				'title'       => $title,
				'categories'  => $categories,
				'series'      => $series,
				'type'        => $type,
				'key'         => $alias,
				'minValue'    => 0,
				'extraSeries' => array(),
			),
		);
	}

	public static function parse_multiple_options_field( $alias, $temp_data ) {
		$calc_id    = sanitize_text_field( $_GET['calc_id'] );
		$calculator = get_post_meta( $calc_id, 'stm-fields', true );

		if ( ! $calculator ) {
			return null;
		}

		$options_field = null;
		$options_field = self::find_field_recursively( $calculator, $alias );

		if ( ! $options_field ) {
			return null;
		}

		$title   = isset( $options_field['label'] ) ? $options_field['label'] : $options_field['text'];
		$options = isset( $options_field['options'] ) ? $options_field['options'] : array();

		if ( empty( $options ) ) {
			return null;
		}

		$categories = array();
		$option_map = array();

		foreach ( $options as $index => $option ) {
			$option_label = isset( $option['optionText'] ) ? $option['optionText'] : 'Untitled option';

			$categories[]         = $option_label;
			$option_map[ $index ] = $option_label;
		}

		$series = array_fill( 0, count( $categories ), 0 );

		if ( isset( $temp_data[ $alias ] ) ) {
			foreach ( $temp_data[ $alias ] as $field_value ) {
				if ( is_array( $field_value ) && isset( $field_value['temps'] ) ) {
					foreach ( $field_value['temps'] as $temp_value ) {
						$parts = explode( '_', $temp_value );
						if ( count( $parts ) >= 2 ) {
							$option_index = (int) end( $parts );

							if ( isset( $option_map[ $option_index ] ) ) {
								$series[ $option_index ]++;
							}
						}
					}
				}
			}
		}

		return array(
			$alias => array(
				'title'       => $title,
				'categories'  => $categories,
				'series'      => $series,
				'type'        => 'bar',
				'key'         => $alias,
				'minValue'    => 0,
				'extraSeries' => array(),
			),
		);
	}

	private static function find_field_recursively( $fields, $target_alias ) {
		foreach ( $fields as $field ) {
			if ( isset( $field['alias'] ) && $field['alias'] === $target_alias ) {
				return $field;
			}

			if ( isset( $field['alias'] ) ) {
				$field_base_alias = $field['alias'];
				if ( preg_match( '/^(.+)_\d+$/', $field['alias'], $matches ) ) {
					$field_base_alias = $matches[1];
				}

				if ( $field_base_alias === $target_alias ) {
					return $field;
				}
			}

			if ( isset( $field['groupElements'] ) && is_array( $field['groupElements'] ) ) {
				$found = self::find_field_recursively( $field['groupElements'], $target_alias );
				if ( $found ) {
					return $found;
				}
			}
		}

		return null;
	}
}
