<?php
/**
 * Template variables:
 *
 * @var $steps
 * @var $available_buttons
 */

$keys     = array_keys( $steps );
$menu_2nd = $keys[1] ?? '#billingAddress';
?>
<div class="checkout-step-btn" data-steps="<?php echo esc_attr( wp_json_encode( $steps ) ); ?>">
	<?php
	if ( $available_buttons['prev'] ) {
		?>
		<a class="prev rtsb-step-btn"  href="<?php echo esc_attr( $menu_2nd ); ?>">
			<?php echo esc_html( $steps[ $menu_2nd ]['prevBtn'] ); ?>
		</a>
		<?php
	}

	if ( $available_buttons['next'] ) {
		?>
		<a class="next rtsb-step-btn" type="submit" href="<?php echo esc_attr( $menu_2nd ); ?>">
			<?php echo esc_html( $steps[ $menu_2nd ]['nextBtn'] ); ?>
		</a>
		<?php
	}

	$order_button_text = apply_filters( 'woocommerce_order_button_text', __( 'Place order', 'shopbuilder-pro' ) );
	?>
	<button type="submit" class="button alt <?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="woocommerce_checkout_place_order" id="place_order" value="<?php echo esc_attr( $order_button_text ); ?>" data-value="<?php echo esc_attr( $order_button_text ); ?>"><?php echo esc_html( $order_button_text ); ?></button>

</div>
