<?php
/**
 * Template: Product Add-Ons Field Type Radio.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var string $full_price
 * @var string $partial_price
 * @var string $due_date
 * @var array  $labels
 * @var array  $installment
 * @var string $default_type
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Modules\PartialPay\PartialPayFns;

// Do not allow direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="rtsb-partial-pay rtsb-partial-pay-wrapper">
	<div class="rtsb-radio-group">
		<?php
		$options = [
			'full'    => [
				'label' => $labels['full_amount'],
				'price' => wc_price( $full_price ),
			],
			'partial' => [
				'label' => $labels['partial_amount'],
				'price' => $partial_price,
			],
		];

		foreach ( $options as $key => $option ) {
			?>
			<label class="rtsb-option">
				<span class="radio-content">
					<input type="radio" name="rtsb_partial_pay_option" value="<?php echo esc_attr( $key ); ?>" <?php checked( $default_type, $key ); ?>>
				</span>
				<div class="rtsb-option-content">
					<span class="rtsb-option-title"><?php echo esc_html( $option['label'] ); ?></span>
					<span class="rtsb-option-price"><?php Fns::print_html( $option['price'] ); ?></span>

					<?php
					if ( 'partial' === $key ) {
						?>
						<span class="rtsb-option-note">
							<?php
							if ( count( $installment ) > 1 ) {
								foreach ( $installment as $index => $inst ) {
									Fns::print_html(
										PartialPayFns::get_formatted_installment_text(
											'multiple_installments',
											[
												'title'    => $inst['title'],
												'amount'   => $inst['amount'],
												'due_date' => $inst['due_date'],
												'index'    => $index,
											]
										)
									);
								}
							} else {
								Fns::print_html(
									PartialPayFns::get_formatted_installment_text(
										'single_installment',
										[
											'label'  => $labels['single_label'],
											'amount' => $installment[0]['amount'],
										]
									)
								);

								Fns::print_html(
									PartialPayFns::get_formatted_installment_text(
										'remaining_amount',
										[
											'label'      => $labels['remaining_label_single'],
											'full_price' => $full_price,
											'amount'     => $installment[0]['amount'],
											'due_date'   => $installment[0]['due_date'],
										]
									)
								);
							}
							?>
						</span>
						<?php
					}
					?>
				</div>
			</label>
			<?php
		}
		?>
	</div>
</div>
