<?php
/**
 * Template variables:
 *
 * @var $order_id int
 * @var $card_number string
 * @var $virtual string
 * @var $expiration_date string
 * @var $product_name string
 * @var $remaining_balance string
 * @var $card_amount string
 * @var $email string
 * @var $sender_name string
 * @var $recipient_name string
 * @var $card_message string
 */

use RadiusTheme\SB\Helpers\Fns;

?>

<div class="rtsb-gift-card-info">
	<h2 class="rtsb-gift-card-info"><?php esc_html_e( 'Info', 'shopbuilder-pro' ); ?></h2>
	<table class="rtsb-gift-card-table shop_table shop_table_responsive">
		<tbody>
		<tr>
			<th ><?php esc_html_e( 'Order ID', 'shopbuilder-pro' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Order ID', 'shopbuilder-pro' ); ?>" >
				<a href="<?php echo esc_html( wc_get_endpoint_url( 'view-order', $order_id, wc_get_page_permalink( 'myaccount' ) ) ); ?>">
					#<?php echo absint( $order_id ); ?>
				</a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e( 'Card Number', 'shopbuilder-pro' ); ?></strong></th>
			<td data-title="<?php esc_attr_e( 'Card Number', 'shopbuilder-pro' ); ?>" ><?php echo esc_html( $card_number ); ?></td>
		</tr>
		<tr>
			<th><?php esc_html_e( 'Card Type', 'shopbuilder-pro' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Card Type', 'shopbuilder-pro' ); ?>" >
				<?php echo 'on' === $virtual ? esc_html__( 'Virtual Card', 'shopbuilder-pro' ) : esc_html__( 'Physical Card', 'shopbuilder-pro' ); ?>
			</td>
		</tr>
		<tr>
			<th><?php esc_html_e( 'Card Amount', 'shopbuilder-pro' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Card Amount', 'shopbuilder-pro' ); ?>" ><?php Fns::print_html( $card_amount ); ?></td>
		</tr>
		<tr>
			<th><?php esc_html_e( 'Current Balance', 'shopbuilder-pro' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Current Balance', 'shopbuilder-pro' ); ?>" ><?php Fns::print_html( $remaining_balance ); ?></td>
		</tr>
		<tr>
			<th><?php esc_html_e( 'Expiration', 'shopbuilder-pro' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Expiration', 'shopbuilder-pro' ); ?>" ><?php echo esc_html( $expiration_date ); ?></td>
		</tr>
		<?php if ( 'on' === $virtual ) { ?>
			<tr>
				<th><?php esc_html_e( 'Recipient Name', 'shopbuilder-pro' ); ?></th>
				<td data-title="<?php esc_attr_e( 'Recipient Name', 'shopbuilder-pro' ); ?>" ><?php echo esc_html( $recipient_name ); ?></td>
			</tr>
			<tr>
				<th><?php esc_html_e( 'Recipient Email', 'shopbuilder-pro' ); ?></th>
				<td data-title="<?php esc_attr_e( 'Recipient Email', 'shopbuilder-pro' ); ?>" ><?php echo esc_html( $email ); ?></td>
			</tr>
			<tr>
				<th><?php esc_html_e( 'Message', 'shopbuilder-pro' ); ?></th>
				<td data-title="<?php esc_attr_e( 'Message', 'shopbuilder-pro' ); ?>" ><?php echo esc_html( ! empty( $card_message ) ? $card_message : '_______' ); ?></td>
			</tr>
		<?php } ?>
		</tbody>
	</table>
</div>
