<?php
/**
 * Template variables:
 *
 * @var $activity Data Array
 */

use RadiusTheme\SB\Helpers\Fns;

?>
<div class="rtsb-gift-card-activity">
	<h2 class="rtsb-gift-card-activity-title"><?php esc_html_e( 'Activity', 'shopbuilder-pro' ); ?></h2>
	<?php if ( ! empty( $activity ) ) { ?>
        <table class="rtsb-gift-card-table shop_table shop_table_responsive">
			<tr>
				<th><?php esc_html_e( 'Users', 'shopbuilder-pro' ); ?></th>
				<th><?php esc_html_e( 'Uses Amount', 'shopbuilder-pro' ); ?></th>
				<th><?php esc_html_e( 'Current Balance', 'shopbuilder-pro' ); ?></th>
				<th><?php esc_html_e( 'Status', 'shopbuilder-pro' ); ?></th>
				<th><?php esc_html_e( 'Date', 'shopbuilder-pro' ); ?></th>
			</tr>
			<?php foreach ( $activity as $row ) { ?>
				<tr>
					<td data-title="<?php esc_attr_e( 'Users', 'shopbuilder-pro' ); ?>" ><?php echo esc_html( $row['user'] ?? null ); ?></td>
					<td data-title="<?php esc_attr_e( 'Uses Amount', 'shopbuilder-pro' ); ?>" ><?php Fns::print_html( wc_price( $row['uses_amount'] ?? null ) ); ?></td>
					<td data-title="<?php esc_attr_e( 'Current Balance', 'shopbuilder-pro' ); ?>" ><?php Fns::print_html( wc_price( $row['current_balance'] ?? null ) ); ?></td>
					<td data-title="<?php esc_attr_e( 'Status', 'shopbuilder-pro' ); ?>" ><?php echo esc_html( $row['status'] ?? null ); ?></td>
					<td data-title="<?php esc_attr_e( 'Date', 'shopbuilder-pro' ); ?>" ><?php echo esc_html( $row['date'] ?? null ); ?></td>
				</tr>
			<?php } ?>
		</table>
	<?php } else { ?>
		<p> <?php esc_html_e( 'No Activity Found', 'shopbuilder-pro' ); ?> </p>
	<?php } ?>
</div>
