<?php
/**
 * Template variables:
 *
 * @var $email_heading string Heading
 * @var $email Data Object
 * @var $activity Data Array
 * @var $email_body String Array
 * @var $redeem_url String
 * @var $email_footer String Email Footer.
 */

use RadiusTheme\SB\Helpers\Fns;

do_action( 'woocommerce_email_header', $email_heading, $email );
?>

	<table cellspacing="0" cellpadding="10" border="0" width="100%" style="border-collapse: collapse; font-family: sans-serif;">
		<tr>
			<td colspan="2"><?php Fns::print_html( $email_body ); ?></td>
		</tr>
		<?php if ( ! empty( $card_number ) ) : ?>
			<tr>
				<td><strong><?php esc_html_e( 'Card Number:', 'shopbuilder-pro' ); ?></strong></td>
				<td><?php echo esc_html( $card_number ); ?></td>
			</tr>
		<?php endif; ?>
		<?php if ( ! empty( $remaining_balance ) ) : ?>
			<tr>
				<td><strong><?php esc_html_e( 'Remaining Balance:', 'shopbuilder-pro' ); ?></strong></td>
				<td><?php Fns::print_html( $remaining_balance ); ?></td>
			</tr>
		<?php endif; ?>

		<?php if ( ! empty( $expiration_date ) ) : ?>
			<tr>
				<td><strong><?php esc_html_e( 'Valid Until:', 'shopbuilder-pro' ); ?></strong></td>
				<td><?php echo esc_html( $expiration_date ); ?></td>
			</tr>
		<?php endif; ?>

	</table>

	<div class="rtsb-gift-card-activity">
		<h2 style="margin: 30px 14px 0;" class="rtsb-gift-card-activity-title"><?php esc_html_e( 'Uses History', 'shopbuilder-pro' ); ?></h2>
		<?php if ( ! empty( $activity ) ) { ?>
			<table>
				<tr>
					<th><?php esc_html_e( 'Users', 'shopbuilder-pro' ); ?></th>
					<th><?php esc_html_e( 'Uses', 'shopbuilder-pro' ); ?></th>
					<th><?php esc_html_e( 'Balance', 'shopbuilder-pro' ); ?></th>
					<th><?php esc_html_e( 'Status', 'shopbuilder-pro' ); ?></th>
					<th><?php esc_html_e( 'Date', 'shopbuilder-pro' ); ?></th>
				</tr>
				<?php foreach ( $activity as $row ) { ?>
					<tr>
						<td><?php echo esc_html( $row['user'] ?? null ); ?></td>
						<td><?php echo wc_price( $row['uses_amount'] ?? null ); ?></td>
						<td><?php echo wc_price( $row['current_balance'] ?? null ); ?></td>
						<td><?php echo esc_html( $row['status'] ?? null ); ?></td>
						<td><?php echo esc_html( $row['date'] ?? null ); ?></td>
					</tr>
				<?php } ?>
			</table>
		<?php } ?>
	</div>

	<div style="margin: 20px 14px;max-width:450px;box-sizing: border-box;text-align: left;">
		<?php Fns::print_html( $email_footer, true ); ?>
	</div>
<?php
do_action( 'woocommerce_email_footer' );