<?php
defined( 'ABSPATH' ) or exit;
$page = 'others';
if ( is_checkout() ) {
	$page = 'checkout';
} elseif ( is_cart() ) {
	$page = 'cart';
}
?>

<div id="rtsb-redeem-gift-card-form" data-page="<?php echo esc_attr( $page ); ?>">
	<div id="rtsb-redeem-gift-card-container">
		<h2 for="rtsb-redeem-gift-card-title"><?php esc_html_e( 'Have a gift card?', 'shopbuilder-pro' ); ?></h2>
		<div id="rtsb-redeem-error"></div>
		<div class="rtsb-wrapper-redeem-field rtsb-d-flex ">
			<input type="text" id="rtsb-redeem-gift-card-number" name="card_number" autocomplete="off" placeholder="<?php esc_html_e( 'Gift card number', 'shopbuilder-pro' ); ?>">
			<button id="rtsb-redeem-button" class="rtsb-redeem-button" data-wait-text="<?php esc_html_e( 'Please wait...', 'shopbuilder-pro' ); ?>">
				<?php esc_html_e( 'Apply', 'shopbuilder-pro' ); ?>
				<span class="rtsb-loader"></span>
			</button>
		</div>
	</div>

</div>


