<?php
/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

global $product;

if ( ! $product->is_purchasable() ) {
	return;
}

echo wc_get_stock_html( $product ); // WPCS: XSS ok.
$product_id = $product->get_id();
if ( $product->is_in_stock() ) : ?>
	<?php do_action( 'woocommerce_before_add_to_cart_form' ); ?>
	<form class="cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data'>
		<?php do_action( 'rtsb_before_add_to_cart_button' ); ?>
		<div class="rtsb_gift_card_template_button variations_button">
			<?php if ( ! $product->is_sold_individually() ) : ?>
                <?php woocommerce_quantity_input( array( 'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( $_POST['quantity'] ) : 1 ) ); //phpcs:ignore --nonce and wc function?>
			<?php endif; ?>
			<button type="submit" class="single_add_to_cart_button rtsb_gift_card_add_to_cart_button button alt" >
				<?php echo esc_html( apply_filters( 'rtsb_add_to_cart_button_text', $product->single_add_to_cart_text() ) ); ?>
			</button>
			<input type="hidden" name="add-to-cart" value="<?php echo absint( $product_id ); ?>" />
			<input type="hidden" name="product_id" value="<?php echo absint( $product_id ); ?>" />
		</div>
	</form>
<?php endif; ?>
