<?php
/**
 * Customer pre-order cancellation email.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/pre-order-cancel.php.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $email                   object
 * @var $email_heading           string
 * @var $order                   object
 * @var $sent_to_admin           bool
 * @var $plain_text              bool
 * @var $store_email             string
 */

use RadiusTheme\SB\Helpers\Fns;

defined( 'ABSPATH' ) || exit();

do_action( 'woocommerce_email_header', $email_heading, $email );

$content      = ! empty( $email->email_content ) ? $email->email_content : '';
$order_id     = $email->object->get_id();
$order_number = $email->object->get_order_number();
$customer     = $order->get_formatted_billing_full_name();
$site_title   = $email->get_blogname();
$site_address = wp_parse_url( home_url(), PHP_URL_HOST );
$site_url     = wp_parse_url( home_url(), PHP_URL_HOST );
$order_link   = '<a href="' . $order->get_view_order_url() . '">' . esc_html__( 'Order#', 'shopbuilder-pro' ) . $order_id . '</a>';

echo '<p>';

$content = nl2br(
	str_replace(
		[
			'{customer_name}',
			'{order_number}',
			'{order_link}',
			'{site_title}',
			'{site_address}',
			'{site_url}',
			'{store_email}',
		],
		[
			ucwords( $customer ),
			$order_number,
			$order_link,
			$site_title,
			$site_address,
			$site_url,
			$store_email,
		],
		$content
	)
);

Fns::print_html( $content, true );
echo '</p>';

do_action( 'woocommerce_email_footer' );
