<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $is_builder_mode    bool Editor Mode status
 * @var $order
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

$show_shipping = ! wc_ship_to_billing_address_only() && $order->needs_shipping_address();

if ( $show_shipping ) {
	?>
	<section class="rtsb-order-thankyou woocommerce-customer-details">
        <h2 class="woocommerce-column__title"><?php esc_html_e( 'Shipping address', 'shopbuilder-pro' ); ?></h2>
        <address>
			<?php echo wp_kses_post( $order->get_formatted_shipping_address( esc_html__( 'N/A', 'shopbuilder-pro' ) ) ); ?>

			<?php if ( $order->get_shipping_phone() ) : ?>
                <p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_shipping_phone() ); ?></p>
			<?php endif; ?>
        </address>
	</section>
	<?php
}