<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $is_builder_mode    bool Editor Mode status
 * @var $order
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

?>
<?php if ( $order ) { ?>
	<div class="rtsb-order-thankyou woocommerce-order">
		<?php
		if ( $order->has_status( 'failed' ) ) {
			?>
			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed">
				<?php if ( ! empty( $controllers['failed_order_received_text'] ) ) { ?>
					<?php echo esc_html( $controllers['failed_order_received_text'] ); ?>
				<?php } else { ?>
					<?php esc_html_e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'shopbuilder-pro' ); ?>
				<?php } ?>
			</p>
			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
				<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>"
				   class="button pay"><?php esc_html_e( 'Pay', 'shopbuilder-pro' ); ?></a>
				<?php if ( is_user_logged_in() ) : ?>
					<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>"
					   class="button pay"><?php esc_html_e( 'My account', 'shopbuilder-pro' ); ?></a>
				<?php endif; ?>
			</p>
		<?php } elseif ( ! empty( $controllers['order_received_text'] ) ) { ?>
			<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo esc_html( $controllers['order_received_text'] ); ?></p>
		<?php } else { ?>
			<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', esc_html__( 'Thank you. Your order has been received.', 'shopbuilder-pro' ), $order ); ?>
			</p>
		<?php } ?>
	</div>
<?php } ?>
