<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $is_builder_mode    bool Editor Mode status
 * @var $order
 * @var $show_title         bool show or hide section title
 */

// Do not allow directly accessing this file.
use RadiusTheme\SB\Helpers\Fns;


if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}
if ( ! $order ) {
	return;
}

$order_items        = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
$show_purchase_note = $order->has_status(
	apply_filters(
		'woocommerce_purchase_note_order_statuses',
		[
			'completed',
			'processing',
		]
	)
);

?>
<section class="rtsb-order-thankyou <?php echo esc_attr( $controllers['layout'] ); ?>">
	<?php do_action( 'woocommerce_order_details_before_order_table', $order ); ?>
	<?php
	if ( $show_title ) {
		?>
		<h2 class="woocommerce-order-details__title"><?php esc_html_e( 'Order details', 'shopbuilder-pro' ); ?></h2>
	<?php } ?>

	<div class="woocommerce-table">
		<?php
		if ( 'yes' === $controllers['show_table_heading'] ) {
			?>
				<div class="order-header item">
					<div class="product-name"><?php esc_html_e( 'Product', 'shopbuilder-pro' ); ?></div>
					<div class="product-total"><?php esc_html_e( 'Total', 'shopbuilder-pro' ); ?></div>
				</div>
			<?php
		}
		?>
		<div class="order-items items">
			<?php
			do_action( 'woocommerce_order_details_before_order_table_items', $order );

			foreach ( $order_items as $item_id => $item ) {
				$product = $item->get_product();
				?>
				<div class="order-single-item item">
					<?php
					$data = [
						'template'           => 'elementor/thankyou/order-details/order-details-item',
						'controllers'        => $controllers,
						'order'              => $order,
						'item_id'            => $item_id,
						'item'               => $item,
						'show_purchase_note' => $show_purchase_note,
						'purchase_note'      => $product ? $product->get_purchase_note() : '',
						'product'            => $product,
					];
					Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );
					?>

				</div>
				<?php
			}
			do_action( 'woocommerce_order_details_after_order_table_items', $order );
			?>
		</div>

		<div class="order-footer items">
			<?php
			foreach ( $order->get_order_item_totals() as $key => $total ) {
				?>
				<div class="footer-item item">
					<div class="label"><?php echo esc_html( $total['label'] ); ?></div>
					<div><?php echo ( 'payment_method' === $key ) ? esc_html( $total['value'] ) : wp_kses_post( $total['value'] ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div>
				</div>
				<?php
			}
			?>
			<?php if ( $order->get_customer_note() ) : ?>
				<div class="footer-item item">
					<div class="label"><?php esc_html_e( 'Note:', 'shopbuilder-pro' ); ?></div>
					<div><?php echo wp_kses_post( nl2br( wptexturize( $order->get_customer_note() ) ) ); ?></div>
				</div>
			<?php endif; ?>
		</div>
	</div>

	<?php do_action( 'woocommerce_order_details_after_order_table', $order ); ?>
</section>
