<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $is_builder_mode    bool Editor Mode status
 * @var $order
 * @var $show_title         bool show or hide section title
 * @var $layout         string template layout
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}
if ( ! $order ) {
	return;
}

$order_items        = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
$show_purchase_note = $order->has_status( apply_filters( 'woocommerce_purchase_note_order_statuses', [ 'completed', 'processing' ] ) );
$layout            .= ! empty( $controllers['table_horizontal_scroll_on_mobile'] ) ? ' rtsb-table-horizontal-scroll-on-mobile' : '';
?>
<section class="rtsb-order-thankyou woocommerce-order-details <?php echo esc_attr( $layout ); ?>">
	<?php do_action( 'woocommerce_order_details_before_order_table', $order ); ?>
	<?php
	if ( $show_title ) {
		?>
		<h2 class="woocommerce-order-details__title"><?php esc_html_e( 'Order details', 'shopbuilder-pro' ); ?></h2>
	<?php } ?>

	<table class="woocommerce-table woocommerce-table--order-details shop_table order_details">

		<thead>
		<tr>
			<th class="woocommerce-table__product-name product-name"><?php esc_html_e( 'Product', 'shopbuilder-pro' ); ?></th>
			<th class="woocommerce-table__product-table product-total"><?php esc_html_e( 'Total', 'shopbuilder-pro' ); ?></th>
		</tr>
		</thead>

		<tbody>
		<?php
		do_action( 'woocommerce_order_details_before_order_table_items', $order );

		foreach ( $order_items as $item_id => $item ) {
			$product = $item->get_product();

			wc_get_template(
				'order/order-details-item.php',
				[
					'order'              => $order,
					'item_id'            => $item_id,
					'item'               => $item,
					'show_purchase_note' => $show_purchase_note,
					'purchase_note'      => $product ? $product->get_purchase_note() : '',
					'product'            => $product,
				]
			);
		}
		do_action( 'woocommerce_order_details_after_order_table_items', $order );
		?>
		</tbody>

		<tfoot>
		<?php
		foreach ( $order->get_order_item_totals() as $key => $total ) {
			?>
			<tr>
				<th scope="row"><?php echo esc_html( $total['label'] ); ?></th>
				<td><?php echo ( 'payment_method' === $key ) ? esc_html( $total['value'] ) : wp_kses_post( $total['value'] ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>
			</tr>
			<?php
		}
		?>
		<?php if ( $order->get_customer_note() ) : ?>
			<tr>
				<th><?php esc_html_e( 'Note:', 'shopbuilder-pro' ); ?></th>
				<td><?php echo wp_kses_post( nl2br( wptexturize( $order->get_customer_note() ) ) ); ?></td>
			</tr>
		<?php endif; ?>
		</tfoot>
	</table>

	<?php do_action( 'woocommerce_order_details_after_order_table', $order ); ?>
</section>
