<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $is_builder_mode    bool Editor Mode status
 * @var $order
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( $order && ! $order->has_status( 'failed' ) ) {
	?>
	<ul class="rtsb-order-thankyou woocommerce-order-overview woocommerce-thankyou-order-details order_details">
		<?php
		if ( 'yes' === $controllers['show_order_number'] ) {
			?>
			<li class="woocommerce-order-overview__order order">
				<?php esc_html_e( 'Order number:', 'shopbuilder-pro' ); ?>
				<strong>

					<?php
					echo $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					?>
				</strong>
			</li>
		<?php } ?>
		<?php
		if ( 'yes' === $controllers['show_order_date'] ) {
			?>
			<li class="woocommerce-order-overview__date date">
				<?php esc_html_e( 'Date:', 'shopbuilder-pro' ); ?>
				<strong>
					<?php
					echo wc_format_datetime( $order->get_date_created() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					?>
				</strong>
			</li>
		<?php } ?>
		<?php if ( is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email() && 'yes' === $controllers['show_order_email'] ) : ?>
			<li class="woocommerce-order-overview__email email">
				<?php esc_html_e( 'Email:', 'shopbuilder-pro' ); ?>
				<strong><?php echo $order->get_billing_email(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
			</li>
		<?php endif; ?>
		<?php
		if ( 'yes' === $controllers['show_order_total'] ) {
			?>
			<li class="woocommerce-order-overview__total total">
				<?php esc_html_e( 'Total:', 'shopbuilder-pro' ); ?>
				<strong>
					<?php
					echo $order->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					?>
				</strong>
			</li>
		<?php } ?>
		<?php if (  'yes' === $controllers['show_order_payment_method'] ) : ?>
			<li class="woocommerce-order-overview__payment-method method">
				<?php esc_html_e( 'Payment method:', 'shopbuilder-pro' ); ?>
				<strong><?php echo wp_kses_post( $order->get_payment_method_title() ); ?></strong>
			</li>
		<?php endif; ?>
	</ul>
	<?php
}

do_action( 'rtsb_woocommerce_thankyou', $order->get_id() );
