<?php
/**
 * Template variables:
 *
 * @var $controllers  array settings as array
 * @var $content  string
 */

// Do not allow directly accessing this file.
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

global $product;
if ( empty( $product ) ) {
	return;
}

$total_sales = '<span class="sales-count"> ' . get_post_meta( $product->get_id(), 'total_sales', true ) . ' </span>';
$icon = '';
if( ! empty( $controllers['sale_count_icon'] ) ){
    $icon = '<span class="icon">' . Fns::icons_manager( $controllers['sale_count_icon'] ) . '</span>';
}

?>
<div class="rtsb-product-sale-count">
    <?php
        $text = '<div class="rtsb-sale-cunter-text">' .( $controllers['sale_counter_text'] ?? '' ) . '</div>';
        Fns::print_html( sprintf( $icon .  $text , $total_sales ) ) ;
    ?>
</div>

