<?php
/**
 * Template variables:
 *
 * @var $controllers  array settings as array
 * @var $show_title_text  boolean title text enable
 * @var $title_text  string title text
 * @var $image_src  string qr code image
 * @var $size  integer qr code size
 */

// Do not allow directly accessing this file.


if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

global $product;
if ( empty( $product ) ) {
	return;
}
?>
 <div class="rtsb-product-qr-code-wrapper" >
		<?php
		if ( 'yes' === $controllers['show_title_text'] && ! empty( $controllers['title_text'] ) ) {
			echo '<div class="qr-title">' . esc_html( $controllers['title_text'] ) . '</div>';
		}

			echo sprintf(
				'<img src="%1$s" alt="%2$s" width="%3$s" height="%3$s">',
				esc_url( $controllers['image_src'] ),
				esc_attr( $product->get_title() ),
				esc_attr( $controllers['size'] )
			);
			?>
 </div>
