<?php
/**
 * Single Product Advanced tabs
 */

/**
 * Template variables:
 *
 * @var $controllers  array settings array
 */

use RadiusTheme\SB\Helpers\BuilderFns;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product, $post;

if ( empty( $product ) ) {
	return;
}

$layout              = ! empty( $controllers['layout_style'] ) ? $controllers['layout_style'] : '';
$product_tabs        = apply_filters( 'woocommerce_product_tabs', [] );
$first_item_collapse = ! empty( $controllers['first_item_collapse'] ) ? 'has-first-item-collapse' : '';
$review_count        = $product->get_review_count();

if ( ! empty( $product_tabs ) ) {
	if ( 'default' === $layout || 'custom-layout2' === $layout ) {
		?>
		<div class="rtsb-product-advanced-tabs rtsb-product-tabs tabs-<?php echo esc_attr( $layout ); ?>">
			<div class="woocommerce-tabs wc-tabs-wrapper">
				<ul class="tabs wc-tabs" role="tablist">
					<?php
					foreach ( $product_tabs as $key => $product_tab ) {
						?>
						<li class="<?php echo esc_attr( $key ); ?>_tab" id="tab-title-<?php echo esc_attr( $key ); ?>" role="tab" aria-controls="tab-<?php echo esc_attr( $key ); ?>">
							<a href="#tab-<?php echo esc_attr( $key ); ?>">
								<?php echo wp_kses_post( $product_tab['title'] ); ?>
							</a>
						</li>
						<?php
					}
					?>
				</ul>

				<?php

				foreach ( $product_tabs as $key => $product_tab ) {
					?>
					<div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--<?php echo esc_attr( $key ); ?> panel entry-content wc-tab<?php echo 'reviews' === $key && $review_count > 0 ? ' has-reviews' : ''; ?>" id="tab-<?php echo esc_attr( $key ); ?>" role="tabpanel" aria-labelledby="tab-title-<?php echo esc_attr( $key ); ?>">
						<?php
						$tab_heading = ! empty( $product_tab['enable_title'] ) ? $product_tab['content_title'] : '';

						if ( ! empty( $tab_heading ) ) {
							?>
							<h2 class="custom-title"><?php echo esc_html( $tab_heading ); ?></h2>
							<?php
						}

						if ( isset( $product_tab['callback'] ) ) {
							if ( 'additional_information' === $key ) {
								do_action( 'woocommerce_product_additional_information', $product );
							} else {
								call_user_func( $product_tab['callback'], $key, $product_tab );
							}
						}

						if ( ! empty( $product_tab['key'] ) && 'custom_tab' === $product_tab['key'] ) {
							echo BuilderFns::is_builder_preview() ? wp_kses_post( $product_tab['desc'] ) : do_shortcode( wp_kses_post( $product_tab['desc'] ) );
						}
						?>
					</div>
					<?php
				}

				do_action( 'woocommerce_product_after_tabs' );
				?>
			</div>
		</div>
		<?php
	} else {
		?>
		<div class="rtsb-product-advanced-tabs rtsb-product-tabs custom-product-tabs tabs-<?php echo esc_attr( $layout." ".$first_item_collapse ); ?>">
			<div class="woocommerce-tabs">
				<?php
				foreach ( $product_tabs as $key => $product_tab ) {
					$tab_heading = ! empty( $product_tab['enable_title'] ) ? $product_tab['content_title'] : '';
					?>
					<div class="rtsb-tab-accordion-item">
						<h2 class="rtsb-accordion-title" id="tab-title-<?php echo esc_attr( $key ); ?>">
							<?php echo wp_kses_post( $product_tab['title'] ); ?>
						</h2>

						<div class="rtsb-product-accordion-content rtsb-custom-tab-panel-<?php echo esc_attr( $key . ( 'reviews' === $key && $review_count > 0 ? ' has-reviews' : '' ) ); ?>" id="tab-<?php echo esc_attr( $key ); ?>" role="tabpanel" aria-labelledby="tab-title-<?php echo esc_attr( $key ); ?>">
							<?php
							$tab_heading = ! empty( $product_tab['enable_title'] ) ? $product_tab['content_title'] : '';

							if ( ! empty( $tab_heading ) ) {
								?>
								<h3 class="custom-title"><?php echo esc_html( $tab_heading ); ?></h3>
								<?php
							}

							if ( isset( $product_tab['callback'] ) ) {
								if ( 'additional_information' === $key ) {
									do_action( 'woocommerce_product_additional_information', $product );
								} else {
									call_user_func( $product_tab['callback'], $key, $product_tab );
								}
							}

							if ( ! empty( $product_tab['key'] ) && 'custom_tab' === $product_tab['key'] ) {
								echo BuilderFns::is_builder_preview() ? wp_kses_post( $product_tab['desc'] ) : do_shortcode( wp_kses_post( $product_tab['desc'] ) );
							}
							?>
						</div>
					</div>
					<?php
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>
