<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $is_builder_mode    bool Editor Mode status
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$address = wc_get_account_formatted_address( 'shipping' );
if ( $is_builder_mode ) {
	$edit_url = '#';
} else {
	$edit_url = wc_get_endpoint_url( 'edit-address', 'shipping' );
}
?>
<div class="rtsb-wc-address woocommerce-MyAccount-content">
	<div class="rtsb-myacount-page woocommerce-Addresses addresses">
		<div class="u-column2 woocommerce-Address">
			<header class="woocommerce-Address-title title">
				<h3><?php echo esc_html_e( 'Shipping address', 'shopbuilder-pro' ); ?></h3>

				<a href="<?php echo esc_url( $edit_url ); ?>" class="edit"><?php echo $address ? esc_html__( 'Edit', 'shopbuilder-pro' ) : esc_html__( 'Add', 'shopbuilder-pro' ); ?></a>
			</header>
			<address>
				<?php
				echo $address ? wp_kses_post( $address ) : esc_html_e( 'You have not set up this type of address yet.', 'shopbuilder-pro' );
				?>
			</address>
		</div>
	</div>
</div>


