<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$remember_me_class = $controllers['show_remember_me'] ? 'show-remember-me' : 'hide-remember-me';
$lost_pass_class   = $controllers['show_lost_password'] ? 'show-lost-password' : 'hide-lost-password';

$remember_me_text = ! empty( $controllers['remember_me_lab_text'] ) ? $controllers['remember_me_lab_text'] : __( 'Remember me', 'shopbuilder-pro' );
$lost_pass_text   = ! empty( $controllers['lost_password_text'] ) ? $controllers['lost_password_text'] : __( 'Lost your password?', 'shopbuilder-pro' );
$login_btn_text   = ! empty( $controllers['login_btn_text'] ) ? $controllers['login_btn_text'] : __( 'Log in', 'shopbuilder-pro' );

?>
<div class="rtsb-myacount-page rtsb-separate-login-form">
	<?php do_action( 'woocommerce_before_customer_login_form' ); ?>
			<div class="rtsb-login-form">
			<?php
			if ( 'yes' === $controllers['show_title'] ) {
				?>
				<h2><?php echo ! empty( $controllers['login_title_text'] ) ? esc_html( $controllers['login_title_text'] ) : esc_html__( 'Login', 'shopbuilder-pro' ); ?></h2>
			<?php } ?>

			<form class="woocommerce-form woocommerce-form-login login" method="post">

				<?php do_action( 'woocommerce_login_form_start' ); ?>

				<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<label for="username"><?php esc_html_e( 'Username or email address', 'shopbuilder-pro' ); ?>&nbsp;<span class="required">*</span></label>
                    <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
				</p>
				<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<label for="password"><?php esc_html_e( 'Password', 'shopbuilder-pro' ); ?>&nbsp;<span class="required">*</span></label>
					<input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="password" id="password" autocomplete="current-password" />
				</p>

				<?php do_action( 'woocommerce_login_form' ); ?>

				<p class="form-row <?php echo esc_attr( $remember_me_class ); ?>">
					<label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
						<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" />
						<span>
						<?php echo esc_html( $remember_me_text ); ?>
					</span>
					</label>
					<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
					<button type="submit" class="woocommerce-button button woocommerce-form-login__submit<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="login" value="<?php echo esc_attr( $login_btn_text ); ?>"><?php echo esc_html( $login_btn_text ); ?></button>
				</p>
				<p class="woocommerce-LostPassword lost_password <?php echo esc_attr( $lost_pass_class ); ?>">
					<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>">
						<?php echo esc_html( $lost_pass_text ); ?>
					</a>
				</p>

				<?php do_action( 'woocommerce_login_form_end' ); ?>

			</form>
			</div>
</div>
