<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $current_page    bool Editor Mode status
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$current_page    = empty( $current_page ) ? 1 : absint( $current_page );
$customer_orders = wc_get_orders(
	apply_filters(
		'woocommerce_my_account_my_orders_query',
		[
			'customer' => get_current_user_id(),
			'page'     => $current_page,
			'paginate' => true,
		]
	)
);
$has_orders      = 0 < $customer_orders->total;
$wp_button_class = wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '';

?>

<?php if ( $has_orders ) : ?>
<section class="rtsb-myacount-page">
	<table class="shop_table_responsive shop_table has-background rtsb-account-table account-orders-table <?php echo esc_attr( $controllers['table_layout'] ); ?>">
		<thead>
		<tr>
			<?php foreach ( wc_get_account_orders_columns() as $column_id => $column_name ) : ?>
				<th class="table-header-<?php echo esc_attr( $column_id ); ?>"><span class="nobr"><?php echo esc_html( $column_name ); ?></span></th>
			<?php endforeach; ?>
		</tr>
		</thead>

		<tbody>
		<?php
		foreach ( $customer_orders->orders as $customer_order ) {
			$order      = wc_get_order( $customer_order );
			$item_count = $order->get_item_count() - $order->get_item_count_refunded();
			?>
			<tr class="order-status-<?php echo esc_attr( $order->get_status() ); ?> order">
				<?php foreach ( wc_get_account_orders_columns() as $column_id => $column_name ) : ?>
					<td class="table-cell-<?php echo esc_attr( $column_id ); ?>" data-title="<?php echo esc_attr( $column_name ); ?>">
						<?php if ( has_action( 'woocommerce_my_account_my_orders_column_' . $column_id ) ) : ?>
							<?php do_action( 'woocommerce_my_account_my_orders_column_' . $column_id, $order ); ?>

						<?php elseif ( 'order-number' === $column_id ) : ?>
							<a href="<?php echo esc_url( $order->get_view_order_url() ); ?>">
								<?php echo esc_html( _x( '#', 'hash before order number', 'shopbuilder-pro' ) . $order->get_order_number() ); ?>
							</a>

						<?php elseif ( 'order-date' === $column_id ) : ?>
							<time datetime="<?php echo esc_attr( $order->get_date_created()->date( 'c' ) ); ?>"><?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?></time>

						<?php elseif ( 'order-status' === $column_id ) : ?>
							<span class="order-status-data"><?php echo esc_html( wc_get_order_status_name( $order->get_status() ) ); ?></span>

						<?php elseif ( 'order-total' === $column_id ) : ?>
							<?php
							/* translators: 1: formatted order total 2: total order items */
							echo wp_kses_post( sprintf( _n( '%1$s for %2$s item', '%1$s for %2$s items', $item_count, 'shopbuilder-pro' ), $order->get_formatted_order_total(), $item_count ) );
							?>

						<?php elseif ( 'order-actions' === $column_id ) : ?>
							<?php
							$actions = wc_get_account_orders_actions( $order );

							if ( ! empty( $actions ) ) {
								foreach ( $actions as $key => $action ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
									echo '<a href="' . esc_url( $action['url'] ) . '" class="woocommerce-button' . esc_attr( $wp_button_class ) . ' button ' . sanitize_html_class( $key ) . '">' . '<span>' . esc_html( $action['name'] ) . '</span>' . '</a>';
								}
							}
							?>
						<?php endif; ?>
					</td>
				<?php endforeach; ?>
			</tr>
			<?php
		}
		?>
		</tbody>
	</table>

	<?php do_action( 'woocommerce_before_account_orders_pagination' ); ?>

	<?php if ( 1 < $customer_orders->max_num_pages ) : ?>
	<div class="woocommerce-pagination woocommerce-pagination--without-numbers woocommerce-Pagination">
		<?php if ( 1 !== $current_page ) : ?>
			<a class="woocommerce-button woocommerce-button--previous woocommerce-Button woocommerce-Button--previous button<?php echo esc_attr( $wp_button_class ); ?>" href="<?php echo esc_url( wc_get_endpoint_url( 'orders', $current_page - 1 ) ); ?>"><?php esc_html_e( 'Previous', 'shopbuilder-pro' ); ?></a>
		<?php endif; ?>

		<?php if ( intval( $customer_orders->max_num_pages ) !== $current_page ) : ?>
			<a class="woocommerce-button woocommerce-button--next woocommerce-Button woocommerce-Button--next button<?php echo esc_attr( $wp_button_class ); ?>" href="<?php echo esc_url( wc_get_endpoint_url( 'orders', $current_page + 1 ) ); ?>"><?php esc_html_e( 'Next', 'shopbuilder-pro' ); ?></a>
		<?php endif; ?>
	</div>
	<?php endif; ?>

	<?php else : ?>

		<div class="rtsb-notice">
			<?php
			if ( function_exists( 'wc_print_notice' ) ) {
				wc_print_notice( esc_html__( 'No order has been made yet.', 'shopbuilder-pro' ) . ' <a class="button wc-forward' . esc_attr( $wp_button_class ) . '" href="' . esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ) . '">' . esc_html__( 'Browse products', 'shopbuilder-pro' ) . '</a>', 'notice' );
			}
			?>
		</div>
</section>
<?php endif; ?>
