<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $order        array settings as array
 * @var $show_shipping         bool show or hide shipping address
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( ! $order ) {
	return;
}
if ( $show_shipping ) {
	?>
	<section class="rtsb-myacount-page woocommerce-customer-details">
		<div class="woocommerce-column  woocommerce-column--shipping-address">
			<h2 class="woocommerce-column__title"><?php esc_html_e( 'Shipping address', 'shopbuilder-pro' ); ?></h2>
			<address>
				<?php echo wp_kses_post( $order->get_formatted_shipping_address( esc_html__( 'N/A', 'shopbuilder-pro' ) ) ); ?>

				<?php if ( $order->get_shipping_phone() ) : ?>
					<p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_shipping_phone() ); ?></p>
				<?php endif; ?>
			</address>
		</div>
	</section>
<?php } ?>
