<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $notes        array settings as array
 * @var $show_title         bool show or hide section title
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<section class="rtsb-myacount-page">
	<?php
	if ( $notes ) {
		if ( $show_title ) {
			?>
			<h2><?php esc_html_e( 'Order updates', 'shopbuilder-pro' ); ?></h2>
		<?php } ?>
		<ol class="woocommerce-OrderUpdates commentlist notes">
			<?php foreach ( $notes as $note ) : ?>
				<li class="woocommerce-OrderUpdate comment note">
					<div class="woocommerce-OrderUpdate-inner comment_container">
						<div class="woocommerce-OrderUpdate-text comment-text">
							<p class="woocommerce-OrderUpdate-meta meta">
								<?php
									$order_note_date = date_i18n( esc_html__( 'l jS \o\f F Y, h:ia', 'shopbuilder-pro' ), strtotime( $note->comment_date ) );
									echo apply_filters( 'rtsb/order/note/data/time', $order_note_date, $note->comment_date ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
								?>
							</p>
							<div class="woocommerce-OrderUpdate-description description">
								<?php echo wpautop( wptexturize( $note->comment_content ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							</div>
							<div class="clear"></div>
						</div>
						<div class="clear"></div>
					</div>
				</li>
			<?php endforeach; ?>
		</ol>
		<?php
	}
	?>
</section>
