<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $show_downloads     bool has downloadable products
 * @var $downloads          array all downloadable products
 * @var $show_title         bool show or hide section title
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$wrapper_classes = ! empty( $controllers['table_horizontal_scroll_on_mobile'] ) ? ' rtsb-table-horizontal-scroll-on-mobile' : '';
?>
<section class="rtsb-myacount-page<?php echo esc_attr( $wrapper_classes ); ?>">
	<?php
	if ( $show_downloads ) {
		wc_get_template(
			'order/order-downloads.php',
			[
				'downloads'  => $downloads,
				'show_title' => $show_title,
			]
		);
	}
	?>
</section>
