<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 * @var $is_builder_mode    bool Editor Mode status
 */

use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_account_navigation' );
?>
<section class="rtsb-myacount-page">
	<nav class="woocommerce-MyAccount-navigation">
		<ul>
			<?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>

				<li class="<?php echo wc_get_account_menu_item_classes( $endpoint ) . ' icon-' . esc_attr( $controllers['icon_alignment'] ); ?>">
					<?php
						$icon_name = $endpoint . '_icon';
					if ( ! empty( $controllers[ $icon_name ]['value'] ) && 'left' === $controllers['icon_alignment'] ) {
						?>
							<span class="icon <?php echo esc_attr( $icon_name ); ?>">
							<?php echo Fns::icons_manager( $controllers[ $icon_name ] ); ?>
							</span>
						<?php
					}

					?>
						<a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
					<?php
					if ( ! empty( $controllers[ $icon_name ]['value'] ) && 'right' === $controllers['icon_alignment'] ) {
						?>
						<span class="icon <?php echo esc_attr( $icon_name ); ?>">
						 <?php echo Fns::icons_manager( $controllers[ $icon_name ] ); ?>
						</span>
						<?php
					}
					?>
				</li>
			<?php endforeach; ?>
		</ul>
	</nav>
</section>

<?php do_action( 'woocommerce_after_account_navigation' ); ?>
