<?php
/**
 * Template variables:
 *
 * @var $controllers        array settings as array
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$remember_me_class = $controllers['show_remember_me'] ? 'show-remember-me' : 'hide-remember-me';
$lost_pass_class   = $controllers['show_lost_password'] ? 'show-lost-password' : 'hide-lost-password';

$remember_me_text  = ! empty( $controllers['remember_me_lab_text'] ) ? $controllers['remember_me_lab_text'] : __( 'Remember me', 'shopbuilder-pro' );
$lost_pass_text    = ! empty( $controllers['lost_password_text'] ) ? $controllers['lost_password_text'] : __( 'Lost your password?', 'shopbuilder-pro' );
$login_btn_text    = ! empty( $controllers['login_btn_text'] ) ? $controllers['login_btn_text'] : __( 'Log in', 'shopbuilder-pro' );
$register_btn_text = ! empty( $controllers['register_btn_text'] ) ? $controllers['register_btn_text'] : __( 'Register', 'shopbuilder-pro' );
?>
<div class="rtsb-myacount-page">
	<?php do_action( 'woocommerce_before_customer_login_form' ); ?>

	<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

		<div class="u-columns col2-set" id="customer_login">

		<div class="u-column1 col-1 rtsb-login-left-col">

	<?php endif; ?>
		<?php
		if ( 'yes' === $controllers['show_title'] ) {
			?>
				<h2><?php esc_html_e( 'Login', 'shopbuilder-pro' ); ?></h2>
			<?php } ?>

		<form class="woocommerce-form woocommerce-form-login login" method="post">

			<?php do_action( 'woocommerce_login_form_start' ); ?>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="username"><?php esc_html_e( 'Username or email address', 'shopbuilder-pro' ); ?>&nbsp;<span class="required">*</span></label>
                <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
			</p>
			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="password"><?php esc_html_e( 'Password', 'shopbuilder-pro' ); ?>&nbsp;<span class="required">*</span></label>
				<input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="password" id="password" autocomplete="current-password" />
			</p>

			<?php do_action( 'woocommerce_login_form' ); ?>

			<p class="form-row <?php echo esc_attr( $remember_me_class ); ?>">
				<label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
					<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" />
					<span>
						<?php echo esc_html( $remember_me_text ); ?>
					</span>
				</label>
				<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
				<button type="submit" class="woocommerce-button button woocommerce-form-login__submit<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="login" value="<?php echo esc_attr( $login_btn_text ); ?>"><?php echo esc_html( $login_btn_text ); ?></button>
			</p>
			<p class="woocommerce-LostPassword lost_password <?php echo esc_attr( $lost_pass_class ); ?>">
				<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>">
					<?php echo esc_html( $lost_pass_text ); ?>
				</a>
			</p>

			<?php do_action( 'woocommerce_login_form_end' ); ?>

		</form>

	<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

		</div>

		<div class="u-column2 col-2 rtsb-login-right-col rtsb-left-border">
			<?php
			if ( 'yes' === $controllers['show_title'] ) {
				?>
				<h2><?php esc_html_e( 'Register', 'shopbuilder-pro' ); ?></h2>
			<?php } ?>

			<form method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action( 'woocommerce_register_form_tag' ); ?> >

				<?php do_action( 'woocommerce_register_form_start' ); ?>

				<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

					<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
						<label for="reg_username"><?php esc_html_e( 'Username', 'shopbuilder-pro' ); ?>&nbsp;<span class="required">*</span></label>
                        <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
					</p>

				<?php endif; ?>

				<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
					<label for="reg_email"><?php esc_html_e( 'Email address', 'shopbuilder-pro' ); ?>&nbsp;<span class="required">*</span></label>
                    <input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
				</p>

				<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

					<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
						<label for="reg_password"><?php esc_html_e( 'Password', 'shopbuilder-pro' ); ?>&nbsp;<span class="required">*</span></label>
						<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" />
					</p>

				<?php else : ?>

					<p class="link"><?php esc_html_e( 'A link to set a new password will be sent to your email address.', 'shopbuilder-pro' ); ?></p>

				<?php endif; ?>

				<?php do_action( 'woocommerce_register_form' ); ?>

				<p class="woocommerce-form-row form-row">
					<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
					<button type="submit" class="woocommerce-Button woocommerce-button button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?> woocommerce-form-register__submit" name="register" value="<?php echo esc_attr( $register_btn_text ); ?>"><?php echo esc_html( $register_btn_text ); ?></button>
				</p>

				<?php do_action( 'woocommerce_register_form_end' ); ?>

			</form>

		</div>

		</div>
	<?php endif; ?>

	<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
</div>
