<?php
/**
 * Template: Product Gallery.
 *
 * @package RadiusTheme\SB
 */

/**
 * Template variables:
 *
 * @var $settings           array    Settings as array
 * @var $gallery_ids        array    product ids as array
 * @var $args               array    Product args
 */

use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( Fns::verify_nonce() && ! empty( $_REQUEST['ajaxData'] ) ) {
	$settings = json_decode( wp_unslash( $_REQUEST['ajaxData'] ), true );
}

if ( Fns::verify_nonce() && ! empty( $_REQUEST['archiveAjaxData'] ) ) {
	$settings = json_decode( wp_unslash( $_REQUEST['archiveAjaxData'] ), true );
}

$rand             = wp_rand();
$has_dynamic_dots = ! empty( $settings['show_product_dynamic_dots'] );
$slider_options   = [
	'spaceBetween'   => 20,
	'speed'          => absint( $settings['product_slide_speed'] ),
	'loop'           => $settings['product_slider_loop'],
	'navigation'     => [
		'nextEl' => '.swiper-gallery-next.rtsb-random-id-' . esc_attr( $rand ),
		'prevEl' => '.swiper-gallery-prev.rtsb-random-id-' . esc_attr( $rand ),
	],
	'pagination'     => [
		'el'             => '.swiper-gallery-pagination.rtsb-random-id-' . esc_attr( $rand ),
		'type'           => 'bullets',
		'clickable'      => true,
		'dynamicBullets' => $has_dynamic_dots,
	],
	'thumbsSelector' => '.product-gallery-thumb',
];

if ( $settings['slider_animation'] ) {
	$slider_options['effect'] = esc_html( $settings['slider_animation'] );
}

if ( $settings['product_slide_autoplay'] ) {
	$slider_options['autoplay'] = [
		'delay'                => absint( $settings['product_autoplay_timeout'] ),
		'pauseOnMouseEnter'    => $settings['product_pause_hover'],
		'disableOnInteraction' => false,
	];
}

$left_icon  = Fns::icons_manager( $settings['product_slider_left_arrow_icon'] );
$right_icon = Fns::icons_manager( $settings['product_slider_right_arrow_icon'] );
?>

<div class="rtsb-gallery-slider product-gallery" data-options=<?php echo esc_js( wp_json_encode( $slider_options ) ); ?>>
	<div class="swiper-wrapper">
		<?php
		foreach ( $gallery_ids as $gallery_id ) {
			$image = Fns::get_product_image_html(
				'product',
				$gallery_id,
				$args['meta']['f_img_size'],
				null,
				$args['meta']['custom_img_size'],
				false,
				false,
				true
			);
			?>
			<div class="swiper-slide">
				<div class="image-wrapper">
					<?php
					if ( $args['image_link'] ) {
						$aria_label = esc_attr(
							/* translators: Product Name */
							sprintf( __( 'Image link for Product: %s', 'shopbuilder-pro' ), $args['title'] )
						);
						?>
						<figure>
							<a class="woocommerce-LoopProduct-link rtsb-img-link" href="<?php echo esc_url( $args['p_link'] ); ?>" aria-label="<?php echo esc_attr( $aria_label ); ?>">
								<?php
								Fns::print_html( $image );
								?>
							</a>
						</figure>
						<?php
					} else {
						echo '<figure class="rtsb-img-link">';
						Fns::print_html( $image );
						echo '</figure>';
					}
					?>
				</div>
			</div>
			<?php
		}
		?>
	</div>
	<?php
	if ( $settings['show_product_nav_arrows'] ) {
		?>
		<div class="swiper-nav ">
			<div class="swiper-arrow swiper-gallery-next rtsb-random-id-<?php echo esc_attr( $rand ); ?>"><?php Fns::print_html( $right_icon ); ?> </div>
			<div class="swiper-arrow swiper-gallery-prev rtsb-random-id-<?php echo esc_attr( $rand ); ?>"><?php Fns::print_html( $left_icon ); ?> </div>
		</div>
		<?php
	}

	if ( $settings['show_product_dots'] ) {
		echo '<div class="swiper-gallery-pagination rtsb-random-id-' . esc_attr( $rand ) . '"></div>';
	}
	?>
</div>

