<?php
/**
 * Template: Product Gallery.
 *
 * @package RadiusTheme\SB
 */

/**
 * Template variables:
 *
 * @var $settings           array    Settings as array
 * @var $gallery_ids        array    product ids as array
 * @var $args               array    Product args
 */

use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( Fns::verify_nonce() && ! empty( $_REQUEST['ajaxData'] ) ) {
	$settings = json_decode( wp_unslash( $_REQUEST['ajaxData'] ), true );
}

if ( Fns::verify_nonce() && ! empty( $_REQUEST['archiveAjaxData'] ) ) {
	$settings = json_decode( wp_unslash( $_REQUEST['archiveAjaxData'] ), true );
}

$rand           = wp_rand();
$slider_options = [
	'slidesPerView' => absint( $settings['gallery_thumb_column_number'] ),
	'spaceBetween'  => absint( $settings['gallery_thumb_column_gap'] ),
	'speed'         => absint( $settings['product_slide_speed'] ),
	'loop'          => false,
];

?>

<div class="product-gallery-thumb" data-options=<?php echo esc_js( wp_json_encode( $slider_options ) ); ?> >
	<div class="swiper-wrapper">
		<?php
		foreach ( $gallery_ids as $gallery_id ) {
			$image = Fns::get_product_image_html(
				'product',
				$gallery_id,
				'thumbnail',
				null,
				[],
				false,
				false,
				true
			);
			?>
			<div class="swiper-slide">
				<div class="image-wrapper">
					<?php
						echo '<figure class="rtsb-img-link">';
						Fns::print_html( $image );
						echo '</figure>';
					?>
				</div>
			</div>
			<?php
		}
		?>
	</div>
</div>

