<?php
/**
 * Template: Lookbook Layout 1
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $product_id                 int
 * @var $product                    object
 * @var $container_attr             string
 * @var $product_title              string
 * @var $p_link                     string
 * @var $img_html                   string
 * @var $hover_img_html             string
 * @var $aria_label                 string
 * @var $add_to_cart                string
 * @var $items                      array
 */

use RadiusTheme\SB\Helpers\Fns;

$GLOBALS['product'] = $product;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}
?>

<div <?php Fns::print_html( $container_attr ); ?>>
	<div class="rtsb-row">
		<div class="rtsb-product rtsb-col-grid rtsb-double-img rtsb-lookbook-popup product-item">
			<div class="rtsb-product-img">
				<figure>
					<a class="woocommerce-LoopProduct-link rtsb-img-link" href="<?php echo esc_url( $p_link ); ?>" aria-label="<?php echo esc_attr( $aria_label ); ?>">
						<?php
						Fns::get_product_image( $img_html, $hover_img_html );
						?>
					</a>
				</figure>

				<div class="rtsb-action-buttons top-part preset6">
					<ul class="rtsb-action-button-list">
						<?php
						Fns::print_html( Fns::get_action_button_by_type( $items, 'wishlist' ) );
						Fns::print_html( Fns::get_action_button_by_type( $items, 'quick_view' ) );
						?>
					</ul>
				</div>

				<?php
				if ( ! empty( $badge_html ) ) {
					?>
					<div class="rtsb-promotion">
						<?php
						Fns::get_badge_html( $badge_html );
						?>
					</div>
					<?php
				}
				?>
			</div>

			<div class="rtsb-product-content">
				<div class="rtsb-product-title-wrapper">
					<h3 class="product-title">
						<a class="woocommerce-LoopProduct-link" href="<?php echo esc_url( $p_link ); ?>"><?php Fns::print_html( $product_title ); ?></a>
					</h3>
				</div>
				<div class="product-price">
					<div class="price-wrapper">
						<?php woocommerce_template_single_price(); ?>
					</div>
				</div>
				<?php
				Fns::get_product_swatches( 'circle' );
				?>
				<div class="rtsb-action-buttons add-to-cart-action">
					<ul class="rtsb-action-button-list">
						<?php
						Fns::print_html( Fns::get_action_button_by_type( $items, 'add_to_cart', $add_to_cart ) );
						?>
					</ul>
				</div>
			</div>
		</div>
	</div>
</div>
