<?php
/**
 * Template: Coupon List Layout 1.
 *
 * @package RadiusTheme\SB
 */

/**
 * Template variables:
 *
 * @var $id                             int
 * @var $coupon_code                    string
 * @var $discount_text                  string
 * @var $coupon_description             string
 * @var $expiry_date                    string
 * @var $formatted_expiry_date          string
 * @var $days_left                      string
 * @var $custom_text                    string
 * @var $grid_attr                      array
 * @var $render                         object
 */

use RadiusTheme\SB\Helpers\Fns;
?>

<div <?php Fns::print_html( $grid_attr ); ?>>
	<div class="rtsb-coupon-card">
		<div class="rtsb-coupon-content">
			<div class="coupon-discount">
				<span class="coupon-discount-value" data-trigger="mouseenter" data-theme="default"><?php Fns::print_html( $discount_text ); ?>
					<?php
					if ( ! empty( $coupon_description ) ) {
						?>
						<span class="coupon-info">
							<span>i</span>
							<span class="coupon-description screen-reader-text rtsb-tippy-data">
								<span class="rtsb-tippy-content">
									<?php echo wp_kses_post( $coupon_description ); ?></span>
								</span>
						</span>
						<?php
					}
					?>
				</span>
			</div>

			<?php
			if ( ! empty( $coupon_code ) ) {
				?>
				<div class="coupon-code"><?php echo esc_html( strtoupper( $coupon_code ) ); ?></div>
				<?php
			}

			if ( ! empty( $formatted_expiry_date ) ) {
				?>
				<div class="coupon-validity">
					<span><?php echo esc_html__( 'Valid until ', 'shopbuilder-pro' ) . esc_html( $formatted_expiry_date ); ?></span>
				</div>
				<?php
			}

			if ( ! empty( $days_left ) ) {
				?>
				<div class="coupon-days-left">
					<span><?php echo $days_left > 0 ? esc_html__( 'Expires in ', 'shopbuilder-pro' ) . absint( $days_left ) . esc_html__( ' Days', 'shopbuilder-pro' ) : esc_html__( 'Expired', 'shopbuilder-pro' ); ?></span>
				</div>
				<?php
			}
			?>
		</div>
		<div class="rtsb-coupon-side">
			<span class="coupon-label"><?php echo esc_html( $custom_text ); ?></span>
		</div>
	</div>
</div>
