<?php
/**
 * Template: Coupon Form
 *
 * @package RadiusTheme\SBPro
 */

/**
 * Template variables:
 *
 * @var $controllers           array    Controllers as array
 */
use RadiusTheme\SB\Helpers\Fns;

$button_icon = Fns::icons_manager( $controllers['button_icon'] );

?>
<div class="rtsb-coupon-wrapper">
	<?php if ( wc_coupons_enabled() ) { ?>
		<h2 class="rtsb-coupon-title"><?php esc_attr_e( 'Apply coupon', 'shopbuilder-pro' ); ?></h2>
		<div class="coupon form-style-<?php echo esc_attr( $controllers['coupon_form_style'] ?? '' ); ?>">
			<label for="coupon_code" class="screen-reader-text"><?php esc_html_e( 'Coupon:', 'shopbuilder-pro' ); ?></label>
			<input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e( 'Coupon code', 'shopbuilder-pro' ); ?>" />
			<button type="submit"
					class="button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>"
					name="apply_coupon"
					value="<?php esc_attr_e( 'Apply coupon', 'shopbuilder-pro' ); ?>">
				<?php
				if ( 'new_line' === $controllers['coupon_form_style'] ) {
					esc_html_e( 'Apply coupon', 'shopbuilder-pro' );
				} else {
					?>
					<span><?php Fns::print_html( $button_icon ); ?></span>
					<?php
				}
				?>
			</button>
		</div>
	<?php } ?>
</div>
