<?php
/**
 * Template variables:
 *
 * @var $tax_type          string        Taxonomy type.
 * @var $attr_type         string        Attribute type.
 * @var $input             string        Input type.
 * @var $title             array         Filter title.
 * @var $multiple          Boolean       Multiple selection.
 * @var $preset            string        Filter layout.
 * @var $template          string        Filter template.
 * @var $raw_settings      array         Widgets/Addons Settings
 * @var $rating_icon       array         Rating icon.
 * @var $repeater_settings array         Repeater Settings
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

$base_url = FnsPro::get_base_url();
?>

<div class="rtsb-product-filters rtsb-ratings">
	<?php
	$ajax_data = [
		'taxonomy' => $tax_type,
		'input'    => $input,
		'multiple' => $multiple,
	];

	$default_rating  = ! empty( $_GET['rating_filter'] ) ? sanitize_text_field( wp_unslash( $_GET['rating_filter'] ) ) : '';
	$active_rating   = explode( ',', $default_rating );
	$show_input_icon = ! empty( $repeater_settings['show_input'] ) ? 'has-input-icons' : 'no-input-icons';
	$columns         = ! empty( $repeater_settings['filter_display'] ) ? ' col-' . $repeater_settings['filter_display'] : ' col-default';

	/**
	 * Filter title.
	 */
	Fns::print_html( FnsPro::get_filter_title( $title ) );

	/**
	 * Filter content.
	 */
	echo '<div class="filter-content ' . esc_attr( $show_input_icon ) . esc_attr( $columns ) . '">';

	echo '<ul class="product-filters" data-rtsb-filter=\'' . esc_js( wp_json_encode( $ajax_data ) ) . '\'>';

	for ( $i = 5; $i >= 1; $i-- ) {
		$unique_id = substr( uniqid(), -6 );
		$checked   = in_array( (string) $i, $active_rating, true ) ? ' checked' : '';
		$active    = in_array( (string) $i, $active_rating, true ) ? ' active' : '';

		echo '<li class="rtsb-term-item">';
		echo '<div class="rtsb-filter-group' . esc_attr( $active ) . '">';
		echo '<input type="checkbox" class="rtsb-ajax-filter-trigger rtsb-checkbox-filter' . esc_attr( $checked ) . '" data-href="' . esc_url( $base_url . '?rating_filter=' . $i ) . '" name="rtsb-checkbox[]" id="rtsb-rating-filter-' . esc_attr( $unique_id ) . '" value="' . absint( $i ) . '">';
		echo '<label class="rtsb-checkbox-filter-label" for="rtsb-rating-filter-' . esc_attr( $unique_id ) . '">';
		echo '<span class="rtsb-rating-star-wrapper">';
		echo '<span class="rtsb-rating-star inactive">';

		for ( $rating = 1; $rating <= 5; $rating++ ) {
			Fns::print_html( Fns::icons_manager( $rating_icon, 'rating-icon' ) );
		}

		echo '</span>';
		echo '<span class="rtsb-rating-star active">';

		for ( $rating = 1; $rating <= $i; $rating++ ) {
			Fns::print_html( Fns::icons_manager( $rating_icon, 'rating-icon' ) );
		}

		echo '</span>';
		echo '</span>';
		echo '<span class="rtsb-count">(' . absint( FnsPro::get_product_rating_count( $i ) ) . ')</span>';
		echo '</label>';
		echo '</div>';
		echo '</li>';
	}

	echo '</ul>';

	echo '</div>';
	?>
</div>
