<?php
/**
 * Template variables:
 *
 * @var $tax_type          string        Taxonomy type.
 * @var $attr_type         string        Attribute type.
 * @var $input             string        Input type.
 * @var $title             array         Filter title.
 * @var $multiple          Boolean       Multiple selection.
 * @var $relation          array         Filter relation.
 * @var $preset            string        Filter layout.
 * @var $template          string        Filter template.
 * @var $raw_settings      array         Widgets/Addons Settings
 * @var $repeater_settings array         Repeater Settings
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Elementor\Render\RenderPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

$tax_type         = FnsPro::get_tax_type( $tax_type, $attr_type );
$columns          = ! empty( $repeater_settings['filter_display'] ) ? ' col-' . $repeater_settings['filter_display'] : ' col-default';
$show_label       = ! empty( $repeater_settings['show_label'] ) ? ' has-label' : ' no-label';
$additional_items = ! empty( $raw_settings['more_less_btn'] );
$additional_count = ! empty( $raw_settings['more_less_items']['size'] ) ? $raw_settings['more_less_items']['size'] : 1000000;
$tax_data         = FnsPro::get_products( $tax_type );
$preset           = ! empty( $raw_settings['color_input_preset'] ) ? ' ' . $raw_settings['color_input_preset'] : ' preset-1';

if ( is_wp_error( $tax_data ) ) {
	Fns::print_html( RenderPro::error_message( $title, 'rtsb-' . esc_attr( $input ) ) );

	return;
}

if ( empty( $tax_data ) ) {
	return;
}
?>

<div class="rtsb-product-filters rtsb-<?php echo esc_attr( $input ); ?>">
	<?php
	$ajax_data       = [
		'taxonomy' => $tax_type,
		'input'    => $input,
		'multiple' => $multiple,
		'relation' => $relation,
		'tax_data' => FnsPro::get_ajax_tax_data( $tax_data ),
	];
	$additional_args = [
		'total_count'      => count( $tax_data ),
		'additional_count' => $additional_count,
		'tax_data'         => $tax_data,
	];

	/**
	 * Filter title.
	 */
	Fns::print_html( FnsPro::get_filter_title( $title ) );

	/**
	 * Filter content.
	 */
	echo '<div class="filter-content' . esc_attr( $columns . $preset ) . '">';

	if ( ! empty( $tax_data ) && ! is_wp_error( $tax_data ) ) {
		list(
			'attribute' => $attribute,
			'term_type' => $term_type,
			'attribute_slug' => $attribute_slug,
			'filter_name' => $filter_name,
			'base_link' => $base_link
			) = FnsPro::get_attribute_term_info( $tax_type );

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$current_filter = isset( $_GET[ $filter_name ] ) ? explode( ',', wc_clean( wp_unslash( $_GET[ $filter_name ] ) ) ) : [];
		$current_filter = array_map( 'sanitize_title', $current_filter );

		$term_info = [
			'attribute'      => $attribute,
			'type'           => $term_type,
			'filter_name'    => $filter_name,
			'base_link'      => $base_link,
			'current_filter' => $current_filter,
		];
		$data      = [
			'terms'            => $tax_data,
			'term_info'        => $term_info,
			'exclude_terms'    => $repeater_settings['exclude_terms'],
			'show_label'       => $show_label,
			'show_tooltips'    => ! empty( $repeater_settings['show_tooltips'] ),
			'show_empty_terms' => ! empty( $repeater_settings['show_empty'] ),
			'additional_items' => $additional_items ? $additional_count : 1000000,
			'count_display'    => ! empty( $raw_settings['color_input_count_display'] ) ? $raw_settings['color_input_count_display'] : 'none',
		];

		Fns::print_html( FnsPro::get_attribute_filter_list_html( $data, $input, $ajax_data ), true );
	} else {
		echo '<p class="no-filter">' . esc_html__( 'Nothing found.', 'shopbuilder-pro' ) . '</p>';
	}

	if ( 'sale_filter' !== $tax_type ) {
		FnsPro::get_more_less_button( $repeater_settings['filter_items'], $raw_settings, $additional_args );
	}

	echo '</div>';
	?>
</div>
