<?php
/**
 * Template variables:
 *
 * @var $class string Endpoint data
 * @var $currency string Endpoint data
 * @var $url string Endpoint data
 * @var $path string Endpoint data
 * @var $currency_info array Endpoint data
 * @var $is_active bool
 * @var $show_flag bool Flag Show Or Hide
 * @var $show_currency_text bool Currency Show oh hide
 */

use RadiusTheme\SB\Helpers\Fns;

?>

<a class="<?php echo esc_attr( $class ); ?>" data-currency="<?php echo esc_attr( $currency ); ?>" href="<?php echo esc_url( $url ); ?>">
	<div class="switcher-toggle-switch <?php echo esc_attr( $is_active ? 'active' : '' ); ?>" onclick="this.classList.toggle('active')" ></div>
	<?php if ( $show_flag && file_exists( $path ) ) { ?>
		<span class="flag-wrapper">
			<?php
            // phpcs:ignore WordPress.WP.AlternativeFunctions.file_get_contents_file_get_contents
			Fns::print_html( file_get_contents( $path ), true );
			?>
		</span>
	<?php } ?>
	<?php if ( $show_currency_text ) { ?>
		<span  class="currency-wrapper"> <?php echo esc_html( $currency_info['title'] ?? '' ); ?> </span>
	<?php } ?>
</a>