<?php
/**
 * Template variables:
 *
 * @var $title array billing Data
 * @var $fields array shipping Data
 */


defined( 'ABSPATH' ) || exit;

?>

<?php if ( ! empty( $fields ) ) { ?>
<div class="rtsb-order-info-table-wrapper rtsb-order-thankyou" >
	<?php if ( ! empty( $title ) ) { ?>
		<h2 class="woocommerce-column__title"> <?php echo esc_html( $title ); ?> </h2>
	<?php } ?>
	<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;" border="1">
		<tbody>
		   <?php
			foreach ( $fields as $field ) {
				$value = is_array( $field['value'] ) ? implode( ', ', $field['value'] ) : $field['value'];
				$value = empty( $value ) ? 'N/A' : $value;
				?>
				<tr>
					<th class="td" scope="row" colspan="2" style="text-align: left"> <?php echo esc_html( $field['label'] ); ?></th>
					<td class="td" > <?php echo \RadiusTheme\SB\Helpers\Fns::print_html( $value, true ); ?> </td>
				</tr>
				<?php
			}
			?>
		</tbody>
	</table>
</div>
<?php } ?>
