<?php
/**
 * Template: Product Add-Ons Price Box.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $product_id                   int
 * @var $product_price                string
 * @var $campaign_price               string
 * @var $preorder_price               string
 * @var $product_type                 string
 * @var $currency_position            string
 * @var $symbol_html                  string
 * @var $visibility                   string
 * @var $total_label                  string
 * @var $classes                      string
 * @var $variation_data               string
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Modules\AddOns\AddOnsFns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}
?>

<div class="rtsb-product-addons-total<?php echo esc_attr( $classes ); ?>"
	 data-product-price="<?php echo esc_attr( $product_price ); ?>"
	 <?php Fns::print_html( ! empty( $variation_data ) ? 'data-variations=' . esc_attr( $variation_data ) : '' ); ?>
	 data-default-product-price="<?php echo esc_attr( 'variable' === $product_type ? 0 : $product_price ); ?>"
	 data-product-type="<?php echo esc_attr( $product_type ); ?>"
	 data-product-id="<?php echo absint( $product_id ); ?>"
	 data-price-decimal-number="<?php echo esc_attr( wc_get_price_decimals() ); ?>"
	 data-currency-position="<?php echo esc_attr( $currency_position ); ?>"
	 data-currency-symbol="<?php Fns::print_html( $symbol_html ); ?>"
>
	<?php
	$price = ! empty( $campaign_price ) ? $campaign_price : $product_price;

	if ( ! empty( $preorder_price ) ) {
		$price = $preorder_price;
	} elseif ( ! empty( $campaign_price ) ) {
		$price = $campaign_price;
	} else {
		$price = $product_price;
	}

	if ( 'all' === $visibility ) {
		?>
		<div class="rtsb-price-item">
			<div class="price-label"><?php esc_html_e( 'Product Price', 'shopbuilder-pro' ); ?></div>
			<?php
			Fns::print_html( AddOnsFns::display_price( 'rtsb-product-total', $price, $currency_position, $symbol_html ) );
			?>
		</div>

		<div class="rtsb-price-item">
			<div class="price-label"><?php esc_html_e( 'Add-Ons Total', 'shopbuilder-pro' ); ?></div>
			<?php
			Fns::print_html( AddOnsFns::display_price( 'rtsb-addon-option-total', 0, $currency_position, $symbol_html ) );
			?>
		</div>
		<?php
	}
	?>
	<div class="rtsb-price-item grand-total">
		<div class="price-label"><?php echo esc_html( $total_label ); ?></div>
		<?php
		Fns::print_html( AddOnsFns::display_price( 'rtsb-grand-total', $price, $currency_position, $symbol_html ) );
		?>
	</div>
</div>
