<?php
/**
 * Template: Product Add-Ons Group Header.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $name                string
 * @var $description         string
 * @var $show_name           string
 * @var $show_desc           string
 * @var $heading_tag         string
 * @var $group_id            int
 */

use RadiusTheme\SB\Helpers\Fns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( 'on' !== $show_name && 'on' !== $show_desc ) {
	return;
}
?>

<div class="rtsb-addons-header">
	<?php
	if ( ! empty( $name ) ) {
		?>
		<<?php echo esc_attr( $heading_tag ); ?> class="rtsb-addons-title">
			<?php
			Fns::print_html( $name );
			?>
		</<?php echo esc_attr( $heading_tag ); ?>>
		<?php
	}

	if ( ! empty( $description ) && 'off' !== $show_desc ) {
		?>
		<div class="rtsb-addons-description">
			<?php
			Fns::print_html( $description );
			?>
		</div>
		<?php
	}
	?>
</div>
