<?php
/**
 * Template: Product Add-Ons Field Type Select.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $field_id            string
 * @var $label               string
 * @var $description         string
 * @var $required            string
 * @var $tooltip             string
 * @var $placeholder         string
 * @var $multiple            string
 * @var $price               string
 * @var $options             array
 * @var $price_display       string
 * @var $field_value         string|array
 * @var $field_required      string
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Modules\AddOns\AddOnsFns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}
?>

<div class="rtsb-addon-field-content rtsb-addon-field-select">
	<select
		id="<?php echo esc_attr( $field_id ); ?>"
		name="<?php echo esc_attr( $field_id ) . ( 'on' === $multiple ? '[]' : '' ); ?>"
		class="rtsb-select-field<?php echo esc_attr( $field_required . ( 'on' === $multiple ? ' has-multi-select' : '' ) ); ?>"
		data-placeholder="<?php echo esc_attr( $placeholder ); ?>"
		data-multi-select="<?php echo esc_attr( $multiple ); ?>"
		<?php echo esc_attr( $field_required ); ?>
	>
		<!-- Placeholder Option -->
		<option value="" disabled selected hidden class="hidden">
			<?php echo esc_html( $placeholder ); ?>
		</option>
		<?php
		if ( ! empty( $options ) && is_array( $options ) ) {
			foreach ( $options as $option ) {
				$options_data = AddOnsFns::field_options_data( $option, $field_value );

				list(
					$option_id,
					$option_name,
					$option_price,
					$default_selected,
					$selected
					) = $options_data;

				$option_price_display = $option_price > 0 ? '(+ ' . wp_strip_all_tags( wc_price( $option_price ) ) . ')' : '';
				?>
				<option
						value="<?php echo esc_attr( $option_name ); ?>"
						data-price="<?php echo esc_attr( $option_price ); ?>"
						data-default="<?php echo $default_selected ? esc_attr( $option_name ) : ''; ?>"
					<?php selected( ! empty( $field_value ) ? $selected : $default_selected ); ?>
				>
					<?php Fns::print_html( $option_name . ' ' . $option_price_display ); ?>
				</option>
				<?php
			}
		} else {
			?>
			<option disabled><?php esc_html_e( 'No options available.', 'shopbuilder-pro' ); ?></option>
			<?php
		}
		?>
	</select>
</div>
