<?php
/**
 * Template: Product Add-Ons Field Type Radio.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $field_id            string
 * @var $label               string
 * @var $description         string
 * @var $required            string
 * @var $tooltip             string
 * @var $placeholder         string
 * @var $price               string
 * @var $options             array
 * @var $price_display       string
 * @var $field_value         string|array
 * @var $field_required      string
 */

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Modules\AddOns\AddOnsFns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}
?>

<div class="rtsb-addon-field-content rtsb-addon-field-radio">
	<div class="rtsb-radio-group<?php echo esc_attr( $field_required ); ?>">
		<?php
		if ( ! empty( $options ) && is_array( $options ) ) {
			foreach ( $options as $option ) {
				$options_data = AddOnsFns::field_options_data( $option, $field_value );

				list(
					$option_id,
					$option_name,
					$option_price,
					$default_checked,
					$is_checked
				) = $options_data;

				$option_price_display = $option_price > 0 ? '(+ ' . wc_price( $option_price ) . ')' : '';
				?>
				<div id="<?php echo esc_attr( $field_id . '_' . $option_id ); ?>" class="rtsb-radio-field">
					<label>
						<span class="radio-content">
							<input
								type="radio"
								id="<?php echo esc_attr( $field_id . '_' . $option_id ); ?>"
								name="<?php echo esc_attr( $field_id ); ?>"
								value="<?php echo esc_attr( $option_name ); ?>"
								data-price="<?php echo esc_attr( $option_price ); ?>"
								<?php checked( ! empty( $field_value ) ? $is_checked : $default_checked ); ?>
							/>
							<span class="rtsb-option-label">
								<?php
								echo esc_html( $option_name );
								?>
							</span>
							<span class="rtsb-addon-price">
								<?php
								Fns::print_html( $option_price_display );
								?>
							</span>
						</span>
					</label>
				</div>
				<?php
			}
		} else {
			?>
			<p><?php esc_html_e( 'No options available.', 'shopbuilder-pro' ); ?></p>
			<?php
		}
		?>
	</div>
</div>
