<?php
/**
 * Template: Product Add-Ons Field Type Number.
 *
 * @package RadiusTheme\SBPRO
 */

/**
 * Template variables:
 *
 * @var $field_id           string  Field ID.
 * @var $label              string  Field label.
 * @var $description        string  Field description.
 * @var $required           string  If the field is required.
 * @var $tooltip            string  Tooltip text.
 * @var $placeholder        string  Placeholder text.
 * @var $price              string  Price attribute.
 * @var $min                string  Minimum value for the number field.
 * @var $max                string  Maximum value for the number field.
 * @var $step               string  Step value for the number field.
 * @var $field_value        string|array
 * @var $field_required     string
 */

// Do not allow direct access to this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}
?>

<div class="rtsb-addon-field-content rtsb-addon-field-number">
	<input
		type="number"
		id="<?php echo esc_attr( $field_id ); ?>"
		name="<?php echo esc_attr( $field_id ); ?>"
		value="<?php echo esc_attr( $field_value ); ?>"
		placeholder="<?php echo esc_attr( $placeholder ); ?>"
		data-price="<?php echo esc_attr( $price ); ?>"
		<?php echo esc_attr( $field_required ); ?>
	/>
</div>
