<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\VariationSwatches;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Modules\VariationSwatches\SwatchesFns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class VariationSwatchesInit {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Asset Handle
	 *
	 * @var string
	 */
	private $handle = 'rtsb-variation-swatches';

	/**
	 * Class construction.
	 */
	private function __construct() {
		$this->handle = Fns::optimized_handle( $this->handle );
		if ( 'on' === SwatchesFns::get_options( 'enable_showcase_swatches' ) ) {
			$this->init();
			ShowCase::instance();
			AdminHooks::instance();
		}
	}

	/**
	 * @return void
	 */
	public function init() {
		add_action( 'wp_enqueue_scripts', [ $this, 'frontend_assets' ], 99 );
		add_action( 'admin_enqueue_scripts', [ $this, 'register_backend_assets' ], 1 );
		add_filter( 'post_class', [ $this, 'product_loop_post_class' ], 25 );
		add_filter( 'woocommerce_loop_add_to_cart_args', [ $this, 'loop_add_to_cart_args' ], 20, 2 );
		add_filter( 'rtsb_product_attribute_is_default_to_image', [ $this, 'attribute_default_button_type' ] );
	}
	/**
	 * Assets.
	 *
	 * @return void
	 */
	public function register_backend_assets() {
		wp_register_style( 'rtsb-variation-admin', rtsbpro()->get_assets_uri( 'css/backend/variation-swatch.css' ), '', '1.0' );
	}
	/**
	 * Undocumented function
	 *
	 * @param string $type type.
	 * @return string
	 */
	public function attribute_default_button_type( $type ) {
		$options = SwatchesFns::get_options();
		if ( 'image' === ( $options['default_dropdown_convert'] ?? '' ) ) {
			$type = 'image';
		}
		return $type;
	}

	/**
	 * Cart Button Data.
	 *
	 * @param array  $args args.
	 * @param object $product product.
	 * @return mixed
	 */
	public function loop_add_to_cart_args( $args, $product ) {
		if ( ! $product->is_type( 'variable' ) ) {
			return $args;
		}
		$options                         = SwatchesFns::get_options();
		$enable_archive_single_attribute = 'on' === ( $options['showcase_single_attribute'] ?? '' );
		if ( ! $enable_archive_single_attribute ) {
			$args['class'] .= ' rtsb_vs_add_to_cart';
		}
		// Based On WooCommerce Settings.
		if ( 'yes' === get_option( 'woocommerce_enable_ajax_add_to_cart' ) && ! $enable_archive_single_attribute ) {
			$args['class'] .= ' rtsb_vs_ajax_add_to_cart';
		} else {
			$args['attributes']['data-product_permalink'] = $product->add_to_cart_url();
			$args['attributes']['data-add_to_cart_url']   = $product->is_purchasable() && $product->is_in_stock() ? SwatchesFns::get_current_url() : get_permalink( $product->get_id() );
		}
		// variation_id.
		$args['attributes']['data-variation_id'] = '';
		$args['attributes']['data-variation']    = '';
		$args['variations']                      = [
			'available_variations' => false,
			'attributes'           => $product->get_variation_attributes(),
			'selected_attributes'  => $product->get_default_attributes(),
		];

		return $args;
	}


	/**
	 * Assets.
	 *
	 * @return void
	 */
	public function frontend_assets() {
		wp_enqueue_script( 'wc-add-to-cart' );
		wp_enqueue_script( 'wc-add-to-cart-variation' );
		$options = SwatchesFns::get_options();
		$params  = [
			'showcase_product_wrapper'      => '.rtsb-vs-product',
			'showcase_single_attribute'     => 'on' === ( $options['showcase_single_attribute'] ?? '' ),
			'showcase_cart_button_selector' => '.rtsb_vs_add_to_cart, .add_to_cart_button, .add_to_cart_button',
			'showcase_cart_select_options'  => '',
			'showcase_price_selector'       => '.price',
			'showcase_image_selector'       => '.attachment-woocommerce_thumbnail, .wp-post-image',
			'showcase_add_to_cart_text'     => '',
			'showcase_display_event'        => $options['showcase_swatches_display_event'] ?? '',
		];

		if ( ! empty( $options['showcase_product_wrapper_selector'] ) ) {
			$params['showcase_product_wrapper'] = $options['showcase_product_wrapper_selector'];
		}
		if ( ! empty( $options['showcase_swatches_image_selector'] ) ) {
			$params['showcase_image_selector'] = $options['showcase_swatches_image_selector'];
		}

		wp_localize_script( $this->handle, 'rtsb_pro_vs_params', apply_filters( 'rtsbpro_vs_js_object', $params ) );
	}

	/**
	 * Page Class function
	 *
	 * @param array $classes Class Name.
	 * @return array
	 */
	public function product_loop_post_class( $classes ) {
		global $product;
		if ( ! $product instanceof \WC_Product ) {
			return $classes;
		}
		if ( ! $product->is_type( 'variable' ) ) {
			return $classes;
		}
		if ( 'on' === SwatchesFns::get_options( 'shape_style_checkmark' ) ) {
			$classes[] = 'rtsb-shape-checkmark ';
		}
		return $classes;
	}
}
