<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\VariationGallery;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class VariationGalleryInit {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Class construction.
	 */
	private function __construct() {
		add_filter( 'attachment_fields_to_edit', [ $this, 'add_media_video_meta' ], 10, 2 );
		add_filter( 'attachment_fields_to_save', [ $this, 'save_media_video_meta' ], 10, 2 );
		add_filter( 'wp_prepare_attachment_for_js', [ $this, 'update_attachment_for_js' ], 10, 3 );
	}

	/**
	 * @param array  $form_fields Fields.
	 * @param object $post Image Post Object.
	 *
	 * @return mixed
	 */
	public function add_media_video_meta( $form_fields, $post ) {
		$form_fields['rtsb_vg_video_link_label'] = [
			'tr' => "<tr><td colspan='2'><h2>" . __( 'VARIATION GALLERY VIDEO', 'shopbuilder-pro' ) . '</h2></td></tr>',
		];
		$form_fields['rtsb_vg_video_link']       = [
			'value' => get_post_meta( $post->ID, 'rtsb_vg_video_link', true ),
			'label' => __( 'Video URL', 'shopbuilder-pro' ),
			'helps' => __( 'Youtube or vimeo video url<br> <a href="#" class="rtsb-vg-media-video-popup">Upload your video <span class="dashicons dashicons-video-alt3"></span></a>', 'shopbuilder-pro' ),
			'input' => 'url',
		];
		$form_fields['rtsb_vg_video_width']      = [
			'label' => esc_html__( 'Width', 'shopbuilder-pro' ),
			'input' => 'text',
			'value' => get_post_meta( $post->ID, 'rtsb_vg_video_width', true ),
			'helps' => esc_html__( 'Video Width. px or %. Empty for default', 'shopbuilder-pro' ),
		];

		$form_fields['rtsb_vg_video_height'] = [
			'label' => esc_html__( 'Height', 'shopbuilder-pro' ),
			'input' => 'text',
			'value' => get_post_meta( $post->ID, 'rtsb_vg_video_height', true ),
			'helps' => esc_html__( 'Video Height. px or %. Empty for default', 'shopbuilder-pro' ),
		];

		return $form_fields;
	}

	/**
	 * @param object $post post object.
	 * @param array  $attachment attachment.
	 * @return mixed
	 */
	public function save_media_video_meta( $post, $attachment ) {
		$post_id = $post['ID'];
		if ( isset( $attachment['rtsb_vg_video_link'] ) ) {
			$rtsb_vg_video_link = trim( $attachment['rtsb_vg_video_link'] );
			update_post_meta( $post_id, 'rtsb_vg_video_link', $rtsb_vg_video_link );
		}
		if ( isset( $attachment['rtsb_vg_video_width'] ) ) {
			update_post_meta( $post_id, 'rtsb_vg_video_width', trim( $attachment['rtsb_vg_video_width'] ) );
		}
		if ( isset( $attachment['rtsb_vg_video_height'] ) ) {
			update_post_meta( $post_id, 'rtsb_vg_video_height', trim( $attachment['rtsb_vg_video_height'] ) );
		}
		return $post;
	}

	/**
	 * @param array  $response response.
	 * @param object $attachment image.
	 * @return mixed
	 */
	public function update_attachment_for_js( $response, $attachment ) {
		$id                             = absint( $attachment->ID );
		$has_video                      = trim( get_post_meta( $id, 'rtsb_vg_video_link', true ) ?? '' );
		$response['rtsb_vg_video_link'] = $has_video;
		return $response;
	}
}
